package com.yeejoin.amos.boot.module.cylinder.biz.job;

import com.yeejoin.amos.boot.module.cylinder.api.entity.CylinderQuestionInfo;
import com.yeejoin.amos.boot.module.cylinder.api.enums.QuestionTypeEnum;
import com.yeejoin.amos.boot.module.cylinder.biz.service.impl.CylinderQuestionInfoServiceImpl;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderUnitDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.mapper.CylinderUnitMapper;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */
@Component
@EnableScheduling
public class CompanyQuestionJob {


    private CylinderUnitMapper cylinderUnitMapper;

    private CylinderQuestionInfoServiceImpl questionInfoService;

    public CompanyQuestionJob(CylinderUnitMapper cylinderUnitMapper,
                              CylinderQuestionInfoServiceImpl questionInfoService) {
        this.cylinderUnitMapper = cylinderUnitMapper;
        this.questionInfoService = questionInfoService;
    }


    /**
     * 资质超期
     */
    @SchedulerLock(name = "genCompanyQuestionOfPermissionExpireJob", lockAtMostFor = "PT30M")
    @Scheduled(cron = "${company.cert.expire.job.cron:0 0 5 * * ?}")
    @Transactional(rollbackFor = Exception.class)
    public void genCompanyQuestionOfPermissionExpire() {
        genCompanyQuestionOfPermissionExpireImpl();
    }

    public void genCompanyQuestionOfPermissionExpireImpl() {
        List<CylinderUnitDto> cylinderUnitDtoList = cylinderUnitMapper.queryCylinderUnitOfPermissionExpire(QuestionTypeEnum.XKCQ.getCode());
        List<CylinderQuestionInfo> cylinderQuestionInfos = cylinderUnitDtoList.stream().map(cylinderUnitDto -> {
            CylinderQuestionInfo cylinderQuestionInfo = new CylinderQuestionInfo();
            cylinderQuestionInfo.setQuestionType(QuestionTypeEnum.XKCQ.getCode());
            cylinderQuestionInfo.setQuestionTypeName(QuestionTypeEnum.XKCQ.getName());
            return this.fillCommonField(cylinderUnitDto, cylinderQuestionInfo);
        }).collect(Collectors.toList());
        if (cylinderQuestionInfos.size() > 0) {
            questionInfoService.saveBatch(cylinderQuestionInfos);
        }
    }

    @NotNull
    private CylinderQuestionInfo fillCommonField(CylinderUnitDto cylinderUnitDto, CylinderQuestionInfo cylinderQuestionInfo) {
        cylinderQuestionInfo.setHappenDate(new Date());
        cylinderQuestionInfo.setRecDate(new Date());
        cylinderQuestionInfo.setRegionCode(cylinderUnitDto.getRegionCode());
        cylinderQuestionInfo.setQuestionObjectId(cylinderUnitDto.getSequenceNbr() + "");
        cylinderQuestionInfo.setQuestionObjectName(cylinderUnitDto.getUnitName());
        cylinderQuestionInfo.setQuestionAttributionId(cylinderUnitDto.getAppId());
        cylinderQuestionInfo.setQuestionAttributionName(cylinderUnitDto.getUnitName());
        return cylinderQuestionInfo;
    }


    /**
     * 未办理使用登记的问题生成
     */
//    @SchedulerLock(name = "genCompanyQuestionOfNoUseRegistrationJob", lockAtMostFor = "PT30M")
//    @Scheduled(cron = "${company.no-use.registration.job.cron:0 0 6 * * ?}")
//    @Transactional(rollbackFor = Exception.class)
    public void genCompanyQuestionOfNoUseRegistration() {
//        genCompanyQuestionOfNoUseRegistrationImpl();
    }

    /**
     * 生成未办理使用登记的问题
     */
    public void genCompanyQuestionOfNoUseRegistrationImpl() {
//        List<CylinderUnitDto> cylinderUnitDtoList = cylinderUnitMapper.queryCylinderUnitOfNoUseRegistration(QuestionTypeEnum.WBLSYDJ.getCode());
//        List<CylinderQuestionInfo> cylinderQuestionInfos = cylinderUnitDtoList.stream().map(cylinderUnitDto -> {
//            CylinderQuestionInfo cylinderQuestionInfo = new CylinderQuestionInfo();
//            cylinderQuestionInfo.setQuestionType(QuestionTypeEnum.WBLSYDJ.getCode());
//            cylinderQuestionInfo.setQuestionTypeName(QuestionTypeEnum.WBLSYDJ.getName());
//            return this.fillCommonField(cylinderUnitDto, cylinderQuestionInfo);
//        }).collect(Collectors.toList());
//        if (cylinderQuestionInfos.size() > 0) {
//            questionInfoService.saveBatch(cylinderQuestionInfos);
//        }
    }


}
