package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jg.api.entity.ShCar;
import com.yeejoin.amos.boot.module.jg.api.entity.ShCarEqu;
import com.yeejoin.amos.boot.module.jg.api.mapper.ShCarEquMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IShCarEquService;
import com.yeejoin.amos.boot.module.jg.api.vo.CarAndEquVo;
import com.yeejoin.amos.boot.module.jg.api.vo.ShCarEquVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2024-11-08
 */
@Service
public class ShCarEquServiceImpl extends BaseService<ShCarEqu,ShCarEqu,ShCarEquMapper> implements IShCarEquService {

    @Autowired
    ShCarServiceImpl shCarServiceImpl;
    /**
     * 分页查询
     */
    public Page<ShCarEqu> queryForShCarEquPage(Page<ShCarEqu> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<ShCarEqu> queryForShCarEquList()   {
        return this.queryForList("" , false);
    }

    public CarAndEquVo queryByCarId(String carId){
        //根据carId获取Car
        LambdaQueryWrapper<ShCar> queryWrapper1= new LambdaQueryWrapper<>();
        queryWrapper1.eq(ShCar::getSequenceNbr,carId);
        ShCar shCar = shCarServiceImpl.getOne(queryWrapper1);
        //根据carId获取设备列表
        LambdaQueryWrapper<ShCarEqu> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ShCarEqu::getCarId,carId);
        List<ShCarEqu> list = this.list(queryWrapper);
        //将设备列表转换为前端可识别bean
        List<ShCarEquVo> collect = list.stream().map(shCarEqu -> new ShCarEquVo(shCarEqu)).collect(Collectors.toList());
        //封装返回VO
        CarAndEquVo carAndEquVo = new CarAndEquVo(shCar, collect);

        return carAndEquVo;
    }


}