package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationEquip;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationEquipMapper;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import javax.annotation.Resource;
import java.util.List;

@Service
@Slf4j
public class HisDataHandlerServiceImpl {

    @Resource
    private JyjcInspectionApplicationEquipMapper jyjcInspectionApplicationEquipMapper;

    @Resource
    private JyjcInspectionApplicationMapper jyjcInspectionApplicationMapper;

    @Transactional(rollbackFor = Exception.class)
    public void pieLineDataHandlerV1() {
        List<JyjcInspectionApplicationEquip> applicationEquips = jyjcInspectionApplicationEquipMapper.queryWaitFlushData();
        log.info("处理前：待压力管道数据条数: {}", applicationEquips.size());
        applicationEquips.forEach(applicationEquip -> {
            // 更新设备表装置id
            LambdaUpdateWrapper<JyjcInspectionApplicationEquip> updateWrapperEquip = new LambdaUpdateWrapper<>();
            updateWrapperEquip.eq(BaseEntity::getSequenceNbr, applicationEquip.getSequenceNbr());
            updateWrapperEquip.set(JyjcInspectionApplicationEquip::getProjectContraptionId, applicationEquip.getProjectContraptionId());
            jyjcInspectionApplicationEquipMapper.update(null, updateWrapperEquip);
            // 更新报检申请表装置id
            LambdaUpdateWrapper<JyjcInspectionApplication> updateWrapperApp = new LambdaUpdateWrapper<>();
            updateWrapperApp.eq(BaseEntity::getSequenceNbr, applicationEquip.getApplicationSeq());
            updateWrapperApp.set(JyjcInspectionApplication::getProjectContraptionId, applicationEquip.getProjectContraptionId());
            jyjcInspectionApplicationMapper.update(null, updateWrapperApp);
        });
        List<JyjcInspectionApplicationEquip> applicationEquipAfter = jyjcInspectionApplicationEquipMapper.queryWaitFlushData();
        log.info("处理前：待压力管道数据条数: {}", applicationEquipAfter.size());
    }
}
