package com.yeejoin.amos.boot.module.jg.biz.reminder.biz.editProject;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.ReminderItemDto;
import com.yeejoin.amos.boot.module.jg.biz.reminder.core.DefaultReminder;
import com.yeejoin.amos.boot.module.jg.biz.reminder.dto.MatchItemDto;
import com.yeejoin.amos.boot.module.jg.biz.reminder.service.CommonReminderService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 装置编辑-提醒处理器
 */
@Component
public class EditProjectReminderAdapter extends DefaultReminder {

    private final EditProjectParseService editProjectParseService;

    public EditProjectReminderAdapter(ApplicationContext applicationContext, EditProjectParseService editProjectParseService) {
        super(applicationContext);
        this.editProjectParseService = editProjectParseService;
    }


    @Override
    protected List<ReminderItemDto> realtimeParse(String bizId) {
        // 创建后，评分使用
        return CommonReminderService.setProjectReminderItemRealTime(bizId, editProjectParseService.getIdxBizJgProjectContraptionServiceImpl());
    }


    @Override
    protected List<ReminderItemDto> jsonParse(String bizId, Map<String, Object> formData) {
        //  新增 + 编辑的保存使用
        IdxBizJgProjectContraption projectContraption = JSON.parseObject(JSON.toJSONString(formData), IdxBizJgProjectContraption.class);
        return CommonReminderService.setProjectReminderItemPageJson(bizId, projectContraption);
    }



    @Override
    protected MatchItemDto setMatchItem(String bizId, Map<String, Object> formData) {
        // 新增 + 编辑的保存使用
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        IdxBizJgProjectContraption projectContraption = JSON.parseObject(JSON.toJSONString(formData), IdxBizJgProjectContraption.class);
        return CommonReminderService.setMatchItemForProject(matchItemDto, projectContraption);
    }




    @Override
    protected MatchItemDto setMatchItem(String bizId) {
        IdxBizJgProjectContraption projectContraption = editProjectParseService.getIdxBizJgProjectContraptionServiceImpl().getById(bizId);
        // 等级 + 详情使用
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        return CommonReminderService.setMatchItemForProject(matchItemDto, projectContraption);
    }


    @Override
    public String supportBizType() {
        return "JG_EDIT_PROJECT";
    }
}
