package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.common.restful.utils.ResponseHelper;
import com.yeejoin.amos.api.common.restful.utils.ResponseModel;
import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.feign.privilege.util.DesUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

@RestController
@RequestMapping(value = "/appId")
@Api(tags = "appid-生成appid类")
public class AppIdMain {
	private static final Logger logger = LogManager.getLogger(AppIdMain.class);

//	public static void main(String[] args) {
//		String appId = DesUtil.encode("000010", Constant.SECRETKEY);
//		logger.info("appId信息：", appId);
//		System.out.println("appId信息：" + appId);
//	}
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "生成AppId")
	@GetMapping(value = "/setAppId")
	public ResponseModel<String> applyAppId (
			@RequestParam String apiCompanyCode) throws Exception
	{
		logger.info("appId信息：",apiCompanyCode);
		String appId = DesUtil.encode(apiCompanyCode, Constant.SECRETKEY);
		logger.info("appToken信息：",appId);
		return ResponseHelper.buildResponse(appId);
	}
}
