package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_maintenance_contract")
public class JgMaintenanceContract extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 维保备案编号
     */
	@TableField("apply_no")
    private String applyNo;

    /**
     * 流程实例id
     */
	@TableField("instance_id")
    private String instanceId;

    /**
     * 办理状态
     */
	@TableField("apply_status")
    private String applyStatus;

    /**
     * 维保备案日期
     */
	@TableField("apply_date")
    private Date applyDate;

    /**
     * 设备类型
     */
	@TableField("equ_type")
    private String equType;

    /**
     * 使用单位统一信用代码
     */
	@TableField("use_unit_code")
    private String useUnitCode;

    /**
     * 使用单位
     */
	@TableField("use_unit_name")
    private String useUnitName;

    /**
     * 接收机构统一信用代码
     */
	@TableField("receive_org_code")
    private String receiveOrgCode;

    /**
     * 接收机构
     */
	@TableField("receive_org_name")
    private String receiveOrgName;

    /**
     * 维保单位统一信用代码
     */
	@TableField("maintenance_unit_code")
    private String maintenanceUnitCode;

    /**
     * 维保单位名称
     */
	@TableField("maintenance_unit_name")
    private String maintenanceUnitName;

    /**
     * 维保合同开始日期
     */
	@TableField("inform_start")
    private Date informStart;

    /**
     * 维保合同结束日期
     */
	@TableField("inform_end")
    private Date informEnd;

    /**
     * 安全管理员id
     */
    @TableField("maintenance_manager_id")
    private String maintenanceManagerId;

    /**
     * 安全管理员姓名
     */
    @TableField("maintenance_manager_name")
    private String maintenanceManagerName;

    /**
     * 安全管理员姓名联系方式
     */
    @TableField("maintenance_manager_phone")
    private String maintenanceManagerPhone;


    /**
     * 维保负责人一id
     */
	@TableField("maintenance_manager_one_id")
    private String maintenanceManagerOneId;

    /**
     * 维保负责人一姓名
     */
    @TableField("maintenance_manager_one_name")
    private String maintenanceManagerOneName;

    /**
     * 维保负责人一联系方式
     */
    @TableField("maintenance_manager_one_phone")
    private String maintenanceManagerOnePhone;

    /**
     * 维保负责人一身份证号码
     */
    @TableField("maintenance_manager_one_id_num")
    private String maintenanceManagerOneIdNum;

    /**
     * 维保负责人二id
     */
    @TableField("maintenance_manager_two_id")
    private String maintenanceManagerTwoId;


    /**
     * 维保负责人二姓名
     */
    @TableField("maintenance_manager_two_name")
    private String maintenanceManagerTwoName;

    /**
     * 维保负责人二联系方式
     */
    @TableField("maintenance_manager_two_phone")
    private String maintenanceManagerTwoPhone;

    /**
     * 维保负责人二身份证号码
     */
    @TableField("maintenance_manager_two_id_num")
    private String maintenanceManagerTwoIdNum;


    /**
     * 紧急救援电话
     */
	@TableField("emergency_call")
    private String emergencyCall;

    /**
     * 24小时维保电话
     */
	@TableField("maintenance_24_tel")
    private String maintenance24Tel;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 录入单位ID
     */
	@TableField("input_unit_no")
    private String inputUnitNo;

    /**
     * 维保合同照片
     */
	@TableField("maintenance_contract")
    private String maintenanceContract;

    /**
     * 维保周期
     */
	@TableField("maintenance_cycle")
    private Integer maintenanceCycle;

    /**
     * 大修周期
     */
	@TableField("overhaul_cycle")
    private Integer overhaulCycle;

    /**
     * 设备数量
     */
	@TableField("equ_num")
    private Integer equNum;


    /**
     * 创建人ID
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建人名称
     */
    @TableField("create_user_name")
    private String createUserName;

    /**
     * 创建时间
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 流程状态
     */
    @TableField("instance_status")
    private String instanceStatus;

    /**
     * 下步执行角色/人id
     */
    @TableField("next_execute_ids")
    private String nextExecuteIds;

    @TableField(value = "promoter", updateStrategy = FieldStrategy.IGNORED)
    private String promoter;

    /**
     * 办理状态
     */
    @TableField("status")
    private String status;

    /**
     *工作流下一节点任务id
     */
    @TableField(value = "next_task_id")
    private String nextTaskId;

    /**
     * 下一节点可执行人
     */
    @TableField("next_execute_user_ids")
    private String nextExecuteUserIds;

    /**
     * 转办后执行人的Id逗号分割
     */
    @TableField("transfer_to_user_ids")
    private String transferToUserIds;


    /**
     * 设备种类
     */
    @TableField("equ_list")
    private String equList;

    /**
     * 设备类别
     */
    @TableField("equ_category")
    private String equCategory;

    /**
     * 其他附件
     */
    @TableField(value = "other_accessories")
    private String otherAccessories;

    /**
     * 接收机构公司的org_code
     */
    @TableField("receive_company_org_code")
    private String receiveCompanyOrgCode;
}
