package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jyjc.api.common.StringUtil;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultParam;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionResultParamMapper;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultParamService;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionResultParamModel;
import com.yeejoin.amos.boot.module.jyjc.biz.utils.JsonUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 检验结果技术参数表服务实现类
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Service
public class JyjcInspectionResultParamServiceImpl extends BaseService<JyjcInspectionResultParamModel,JyjcInspectionResultParam,JyjcInspectionResultParamMapper> implements IJyjcInspectionResultParamService {

    @Value("classpath:/json/equipParam.json")
    private Resource equipParam;

    /**
     * 分页查询
     */
    public Page<JyjcInspectionResultParamModel> queryForJyjcInspectionResultParamPage(Page<JyjcInspectionResultParamModel> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<JyjcInspectionResultParamModel> queryForJyjcInspectionResultParamList()   {
        return this.queryForList("" , false);
    }

    @Override
    public List<JyjcInspectionResultParam> getParamByResultSeq(Long sequenceNbr) {
        LambdaQueryWrapper<JyjcInspectionResultParam> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(JyjcInspectionResultParam::getResultSeq, sequenceNbr);
        return this.baseMapper.selectList(wrapper);
    }

    @Override
    public List<Map<String, Object>> getParamByEquipTypeCode(String equipTypeCode) {
        List<Map<String, Object>> paramList = new ArrayList<>();
        Map<String, List<Map<String, Object>>> paramJson = JsonUtils.getResourceJson(equipParam);
        if (StringUtil.isNotEmpty(equipTypeCode)) {
            paramList = ObjectUtils.isEmpty(paramJson.get(equipTypeCode)) ? new ArrayList<>() : paramJson.get(equipTypeCode);
        }
        return paramList;
    }
}