package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 用户信息
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TzsUseInfo", description = "用户信息")
public class TzsUserInfoDto extends BaseDto {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "证件类型")
    private String certificateType;

    @ApiModelProperty(value = "证件编号")
    private String certificateNum;

    @ApiModelProperty(value = "性别")
    private String gender;

    @ApiModelProperty(value = "岗位")
    private String post;

    @ApiModelProperty(value = "岗位名称")
    private String postName;

    @ApiModelProperty(value = "联系电话")
    private String phone;

    @ApiModelProperty(value = "出生日期")
    private Date birthday;

    @ApiModelProperty(value = "学历")
    private String education;

    @ApiModelProperty(value = "专业")
    private String speciality;

    @ApiModelProperty(value = "邮箱")
    private String email;

    @ApiModelProperty(value = "住址")
    private String address;

    @ApiModelProperty(value = "证件照片")
    private String identification;

    @ApiModelProperty(value = "头像")
    private String profile;

    @ApiModelProperty(value = "账户名")
    private String amosUserName;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "平台账号id")
    private String amosUserId;

    @ApiModelProperty(value = "年龄")
    private Integer age;

    @ApiModelProperty(value = "人员内部编码")
    private String innerPersonCode;
}
