package com.yeejoin.amos.boot.module.jg.api.mapper;


import com.yeejoin.amos.boot.module.jg.api.dto.JgInstallationNoticeEqDto;
import com.yeejoin.amos.boot.module.jg.api.dto.PieLineEquipContraptionDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNoticeEq;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 安装告知设备关系表 Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-18
 */
public interface JgInstallationNoticeEqMapper extends CustomBaseMapper<JgInstallationNoticeEq> {


    /**
     * 查询安装告知完成但是纳管状态非已纳管的管道
     *
     * @return List<JgInstallationNoticeEq> 管道record数组
     */
    List<JgInstallationNoticeEq> selectErrorRecordOfInIntoManage();

    /**
     * 查询安装告知（非删除、已作废）的装置id和设备的使用信息装置id不一样的设备
     *
     * @return List<JgInstallationNoticeEq> 管道record数组
     */
    List<JgInstallationNoticeEq> selectPCIdNeErrorPieLineInUseInfo();


    /**
     * 查询安装告知（非删除、已作废）的装置id和设备的使用信息装置id不一样的设备
     *
     * @return List<JgInstallationNoticeEq> 管道record数组
     */
    List<PieLineEquipContraptionDto> selectPCIdNeErrorPieLineInUseInfo2();

    /**
     * 查询存在多个安装告知的设备-管道
     *
     * @return List<JgInstallationNoticeEq> 管道record数组
     */
    List<PieLineEquipContraptionDto> selectPCIdNeErrorPieLineInUseInfo3();


    /**
     * 查询管道对应的安装告知单
     *
     * @return List<JgInstallationNoticeEqDto> 管道对应的最新安装告知
     */
    JgInstallationNoticeEqDto selectLatestNoticeByRecord(@Param("record") String record) ;


}
