package com.yeejoin.amos.boot.module.tcm.api.dto;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 用户信息
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TzsUseInfo", description = "用户信息")
public class TzsUserInfoDto extends BaseDto {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "证件类型")
    private String certificateType;

    @ApiModelProperty(value = "证件编号")
    private String certificateNum;

    @ApiModelProperty(value = "性别")
    private String gender;

    @ApiModelProperty(value = "岗位")
    private String post;

    @ApiModelProperty("新岗位（后期post迁移数组至此）")
    private String newPost;

    @ApiModelProperty(value = "岗位名称")
    private String postName;

    @ApiModelProperty(value = "联系电话")
    private String phone;

    @ApiModelProperty(value = "出生日期")
    private Date birthday;

    @ApiModelProperty(value = "学历")
    private String education;

    @ApiModelProperty(value = "专业")
    private String speciality;

    @ApiModelProperty(value = "邮箱")
    private String email;

    @ApiModelProperty(value = "住址")
    private String address;

    @ApiModelProperty(value = "证件照片")
    private String identification;

    @ApiModelProperty(value = "头像")
    private String profile;

    @ApiModelProperty(value = "账户名")
    private String amosUserName;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "单位编码")
    private String unitCode;

    @ApiModelProperty(value = "平台账号id")
    private String amosUserId;

    @ApiModelProperty(value = "年龄")
    private Integer age;

    @ApiModelProperty(value = "平台账号锁定状态")
    private String lockStatus;

    @ApiModelProperty(value = "设备类型")
    private String equipType;

    @ApiModelProperty(value = "设备绑定状态")
    private String state;

    @ApiModelProperty(value = "任命文件")
    private String appointDoc;

    @ApiModelProperty(value = "人员内部编码")
    private String innerPersonCode;

    @ApiModelProperty(value = "其他附件")
    private String otherAccessories;

    @ApiModelProperty(value = "验检验专用-资质数据json")
    private String permissionData;

    @ApiModelProperty(value = "检验资质json, 固定前缀permissionData,入库时数据存放到permissionData")
    private JSONArray permissionData66151;

    @ApiModelProperty(value = "检测资质json,固定前缀permissionData,入库时数据存放到permissionData")
    private JSONArray permissionData66152;

    @ApiModelProperty(value = "作业人员资质信息json,固定前缀permissionData,入库时数据存放到permissionData")
    private JSONArray permissionData6552;

    @ApiModelProperty(value = "职称")
    private String jobTitle;

    @ApiModelProperty(value = "菜单类型，具体见TzsUserInfoServiceImpl中的menuMap")
    private String menuType;

    @ApiModelProperty(value = "菜单类型下的所有人员类型")
    private List<String> menuTypeUnderPost;

    @ApiModelProperty("二维码状态0异常1正常")
    private String qrCodeState;

}
