package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author ZeHua Li
 * @date 2020/10/30 11:12
 * @since v2.0
 */
@Data
@TableName("wl_equipment_specific_index")
@ApiModel(value = "EquipmentSpecificIndex对象", description = "性能指标参数")
public class EquipmentSpecificIndex extends BaseEntity {

    @ApiModelProperty(value = "单个设备id")
    @TableField("equipment_specific_id")
    private Long equipmentSpecificId;

    @ApiModelProperty(value = "值")
    @TableField("value")
    private String value;

    @ApiModelProperty(value = "值说明")
    @TableField("value_label")
    private String valueLabel;

    @ApiModelProperty(value = "性能指标对应id")
    @TableField("equipment_index_id")
    private Long equipmentIndexId;

    @ApiModelProperty(value = "更新时间")
    @TableField("update_date")
    private Date updateDate;

    @ApiModelProperty(value = "装备名称（冗余字段）")
    @TableField("equipment_specific_name")
    private String equipmentSpecialName;

    @ApiModelProperty(value = "指标名称（冗余字段）")
    @TableField("equipment_index_name")
    private String equipmentIndexName;

    @ApiModelProperty(value = "指标key（冗余字段）")
    @TableField("equipment_index_key")
    private String equipmentIndexKey;

    @TableField(exist = false)
    private String nameKey;

    @TableField(exist = false)
    private String code;

    @TableField(exist = false)
    private String iotCode;

    @TableField(exist = false)
    private String type;

    @TableField(exist = false)
    private String orgCode;

    @TableField(exist = false)
    private String typeCode;

    @TableField(exist = false)
    private String typeName;

    @TableField(exist = false)
    private String indexName;
    
    @TableField(exist = false)
    private String equipmentSpecificName;
    
    @TableField(exist = false)
    private String equipmentSpecificIndexName;

    @TableField(exist = false)
    private String indexUnitName;

    @TableField(exist = false)
    private String qrCode;

    @TableField(exist = false)
    private String equipmentCode;

    @TableField(exist = false)
    private Long equipmentId;

    @TableField(exist = false)
    private Long equipmentDetailId;

    @TableField(exist = false)
    private String alamReason;

    @TableField(exist = false)
    private String valueEnum;
}
