package com.yeejoin.equipmanage.common.entity.vo;

import com.yeejoin.equipmanage.common.entity.UploadFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author ZeHua Li
 * @date 2020/9/15 15:14
 * @since v2.0
 */
@Data
@ApiModel(value = "EquipmentAppVO实体", description = "app查询装备基础信息实体类")
public class EquipmentBaseAppVO {
    @ApiModelProperty(value = "装备实例id")
    private Long equipmentSpecificId;
    @ApiModelProperty(value = "装备定义id")
    private Long equipId;
    @ApiModelProperty(value = "装备实例明细id")
    private Long equipDetailId;
    @ApiModelProperty(value = "设备名称")
    private String equipName;
    @ApiModelProperty(value = "设备编码")
    private String equipCode;
    @ApiModelProperty(value = "报废年限")
    private String expiryDate;
    @ApiModelProperty(value = "规格型号")
    private String standard;
    @ApiModelProperty(value = "国别")
    private String country;
    @ApiModelProperty(value = "保养周期")
    private String maintenanceCycle;
    @ApiModelProperty(value = "生产厂商")
    private String manufacturerName;
    @ApiModelProperty(value = "品牌")
    private String brand;
    @ApiModelProperty(value = "分类名称")
    private String categoryName;
    @ApiModelProperty(value = "位置信息")
    private String description;
    @ApiModelProperty(value = "入库时间")
    private String createTime;
    private Long manufacturerId;
    @ApiModelProperty(value = "轮播图")
    List<UploadFile> img;
    private String sysName;
    @ApiModelProperty(value = "二维码code")
    private String qrCode;

    @ApiModelProperty(value = "实时状态")
    private String alarmType;

    @ApiModelProperty(value = "更新時間")
    private String alarmTime;

}
