package com.yeejoin.amos.fas.common.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @author suhg
 */

public enum View3dRefreshAreaEum {
    /**
     * 3d页面数据区域(triggerBy枚举定义见DataRefreshTypeEum.java)
     */
    all("全部区域", "all", "dateChange"),
    today_safety_index("今日安全指数", "today_safety_index", "rpn,check,trouble,handleDanger"),
    fire_safety("消防安全执行", "fire_safety", "alarm,rpn,check,trouble"),
    monitor_data("设备状态检测数据","monitor_data","monitor"),
    error_status("异常区域", "error_status", "rpn,trouble"),
    week_safety_index("一周安全指数趋势", "week_safety_index", "rpn,check,handleDanger"),
    today_check_status("今日巡检情况", "today_check_status", "planTask,check"),
    today_duty("今日值班", "today_duty", "dutyChange");


    private String code;

    private String name;

    private String triggerBy;

    View3dRefreshAreaEum(String name, String code, String triggerBy) {
        this.name = name;
        this.code = code;
        this.triggerBy = triggerBy;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTriggerBy() {
        return triggerBy;
    }

    public void setTriggerBy(String triggerBy) {
        this.triggerBy = triggerBy;
    }

    public static List<View3dRefreshAreaEum> getEumListByTrigger(String trigger) {
        List<View3dRefreshAreaEum> eumList = new ArrayList<>();
        for (View3dRefreshAreaEum eum : View3dRefreshAreaEum.values()) {
            if (eum.getTriggerBy().contains(trigger)) {
                eumList.add(eum);
            }
        }
        return eumList;
    }

    public static View3dRefreshAreaEum getEumByCode(String code) {
        for (View3dRefreshAreaEum eum : View3dRefreshAreaEum.values()) {
            if (code.equals(eum.getCode())) {
                return eum;
            }
        }
        return null;
    }
}
