package com.yeejoin.amos.boot.module.tzs.flc.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledQueryDto;
import com.yeejoin.amos.boot.module.tzs.biz.utils.BeanDtoVoUtils;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.InformEquipmentDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.UnitInfoDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.EquipmentInform;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.UnitInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl.EquipmentInformServiceImpl;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.EquipmentInformDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 设备告知单
 *
 * @author system_generator
 * @date 2021-12-10
 */
@RestController
@Api(tags = "设备告知单Api")
@RequestMapping(value = "/equipment-inform")
public class EquipmentInformController extends BaseController {

    @Autowired
    EquipmentInformServiceImpl equipmentInformServiceImpl;

	/**
	 * 根据regionCode 获取设备告知单单号
	 * @param regionCode
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getInformCode/{regionCode}")
	@ApiOperation(httpMethod = "GET",value = "根据regionCode 获取设备告知单单号",  notes = "根据regionCode 获取设备告知单单号")
	public ResponseModel<String> getInformCode(@PathVariable String regionCode) {
		// 行政编码 + 年月 + 顺序号
		String code = regionCode +DateUtils.getDateNowShortNumber();
		int number = equipmentInformServiceImpl.count(new LambdaQueryWrapper<EquipmentInform>().like(EquipmentInform::getProductCode,regionCode));
		String numberStr = String.format("%04d", number);
		code += numberStr;
		return ResponseHelper.buildResponse(code);
	}

    /**
     * 新增设备告知单
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增设备告知单", notes = "新增设备告知单")
	public ResponseModel<EquipmentInformDto> save(@RequestBody EquipmentInformDto model) {
	    model = equipmentInformServiceImpl.createEquipmentInform(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/updateEquipmentInform")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新设备告知单", notes = "根据sequenceNbr更新设备告知单")
	public ResponseModel<EquipmentInformDto> updateBySequenceNbrEquipmentInform(@RequestBody EquipmentInformDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(equipmentInformServiceImpl.updateWithModel(model));
	}


    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个设备告知单",  notes = "根据sequenceNbr查询单个设备告知单")
	public ResponseModel<EquipmentInformDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(equipmentInformServiceImpl.queryBySeq(sequenceNbr));
	}


	/**
	 * 列表分页查询
	 *
	 * @param pageNum  当前页
	 * @param pageSize 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/list")
	@ApiOperation(httpMethod = "GET", value = "告知书列表查询", notes = "告知书列表查询")
	public ResponseModel<Page<EquipmentInformDto>> queryForPage(@RequestParam(value = "pageNum") int pageNum, @RequestParam(value = "pageSize") int pageSize, String sort , EquipmentInformDto equipmentInformDto) {
		Page<EquipmentInformDto> page = new Page<EquipmentInformDto>();
		page.setCurrent(pageNum);
		page.setSize(pageSize);
		String sortParam = "";
		String sortRule = "";
		if(sort!=null) {  // 排序失效
			String[] date=  sort.split(",");
			if(date[1].equals("ascend")) {
				sortParam = RedisKey.humpToLine(date[0]);
				sortRule = "asc";
			}else {
				sortParam =RedisKey.humpToLine(date[0]);
				sortRule = "desc";
			}
		}else {
			sortParam = "rec_date";
			sortRule = "desc";
		}
		Page<EquipmentInformDto> pageBean = equipmentInformServiceImpl.queryDtoList(page,equipmentInformDto,sortParam,sortRule);
		Page<EquipmentInformDto> result = new Page<EquipmentInformDto>(pageNum,pageSize);
		long totle = pageBean.getTotal();
		result.setRecords(pageBean.getRecords());
		result.setTotal(totle);
		return ResponseHelper.buildResponse(result);
	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/delete_batch")
	@ApiOperation(httpMethod = "DELETE", value = "批量删除告知书信息", notes = "批量删除告知书信息")
	public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam(value = "sequenceNbrList") List<Long> sequenceNbrList){
		return ResponseHelper.buildResponse(equipmentInformServiceImpl.batchDelete(sequenceNbrList));
	}






}
