package com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.SourceFileServiceImpl;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledQueryDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.EquipmentDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.EquipmentIndexDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.InformEquipmentDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.Equipment;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.EquipmentIndex;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.EquipmentInform;
import com.yeejoin.amos.boot.module.tzs.flc.api.enums.EquipmentInformStatusEnum;
import com.yeejoin.amos.boot.module.tzs.flc.api.enums.EquipmentStatusEnum;
import com.yeejoin.amos.boot.module.tzs.flc.api.mapper.EquipmentInformMapper;
import com.yeejoin.amos.boot.module.tzs.flc.api.service.IEquipmentInformService;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.EquipmentInformDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.service.IInformEquipmentService;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 设备告知单服务实现类
 *
 * @author system_generator
 * @date 2021-12-10
 */
@Service
public class EquipmentInformServiceImpl extends BaseService<EquipmentInformDto,EquipmentInform,EquipmentInformMapper> implements IEquipmentInformService {

    @Autowired
    SourceFileServiceImpl sourceFileService;


    @Autowired
    EquipmentServiceImpl equipmentServiceImpl;

    @Autowired
    OrgUsrServiceImpl iOrgUsrService;

    @Autowired
    EquipmentIndexServiceImpl equipmentIndexServiceImpl;

    @Autowired
    InformEquipmentServiceImpl informEquipmentServiceImpl;

    /**
     * 分页查询
     */
    public Page<EquipmentInformDto> queryForEquipmentInformPage(Page<EquipmentInformDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<EquipmentInformDto> queryForEquipmentInformList()   {
        return this.queryForList("" , false);
    }

    @Override
    public EquipmentInformDto createEquipmentInform(EquipmentInformDto model) {
        // 获取用户所在单位 保存施工单位所属信息
        OrgUsr myUnit = null;
        AgencyUserModel user = Privilege.agencyUserClient.getme().getResult();
        List<CompanyModel> companys = user.getCompanys();
        for(CompanyModel c : companys) {
            myUnit = iOrgUsrService.getOne(new LambdaQueryWrapper<OrgUsr>().eq(OrgUsr::getIsDelete,false).eq(OrgUsr::getAmosOrgId,c.getSequenceNbr()));
        }
        if(myUnit == null) {
            throw  new BadRequest("该用户非施工单位人员无法创建告知单");
        }
        // 判断是暂存还是提交
        if(EquipmentInformStatusEnum.未接收.getCode().equals(model.getInformStatus())) { // 提交判断日期
            if(model.getPlanProductDate() == null) {
                throw new BadRequest("未填写计划施工日期");
            }
            if(( model.getPlanProductDate().getTime() - System.currentTimeMillis() ) < 3*24*60*60*1000 ) {
                throw new BadRequest("计划施工日期比现在时间至少提前3天");
            }
        }
        model.setProductInformDate(new Date());


        model.setProductUnitId(myUnit.getSequenceNbr());
        model.setProductUnit(myUnit.getBizOrgName());
        model = this.createWithModel(model);
        saveSourceFile(model);
        return model;
    }

    @Override
    public Page<EquipmentInformDto> queryDtoList(Page<EquipmentInformDto> page, EquipmentInformDto equipmentInformDto, String sortParam, String sortRule) {
        Page<List<EquipmentInformDto>>list = baseMapper.queryDtoList(page,equipmentInformDto.getProductCode(),equipmentInformDto.getProductInformDateStart(),equipmentInformDto.getProductInformDateEnd(),
                equipmentInformDto.getProductUnitId(),equipmentInformDto.getRegionCode(),equipmentInformDto.getAddress(),equipmentInformDto.getPlanProductDateStart(),equipmentInformDto.getPlanProductDateEnd(),
                equipmentInformDto.getAcceptUnitId(),equipmentInformDto.getInformStatus(),sortParam,sortRule);
        Page<EquipmentInformDto> page1 = new Page<>();
        List<EquipmentInformDto> resultDtoList = JSONArray.parseArray(JSONArray.toJSONString(list.getRecords()),EquipmentInformDto.class);
        page1.setCurrent(page.getCurrent());
        page1.setSize(page.getSize());
        page1.setTotal(list.getTotal());
        page1.setRecords(resultDtoList);
        return page1;
    }

    @Transactional
    @Override
    public Boolean batchDelete(List<Long> sequenceNbrList) {
        for(Long sequenceNbr : sequenceNbrList) {
            if(! this.update(new LambdaUpdateWrapper<EquipmentInform>().eq(EquipmentInform::getSequenceNbr,sequenceNbr).set(EquipmentInform::getIsDelete,true))) {
                throw new BadRequest("删除" + sequenceNbr +"告知书失败");
            }
        }
        return true;
    }

    // 保存附件信息
    public void saveSourceFile(EquipmentInformDto model) {
        if (model.getAttachments() != null) {
            sourceFileService.saveAttachments(model.getSequenceNbr(), model.getAttachments());
        }
    }
}