package com.yeejoin.amos.boot.module.elevator.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 人员数据信息-基本信息
 *
 * @author cpp
 * @date 2023-04-06 15:21:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="MidStaffBaseInfoDto", description="人员数据信息-基本信息Dto")
public class StaffBaseInfoModel extends BaseDto {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "作业人员姓名")
    private String operator;
    @ApiModelProperty(value = "作业人员证件类型")
    private String operatorIdType;
    @ApiModelProperty(value = "作业人员身份号码")
    private String operatorId;
    @ApiModelProperty(value = "性别")
    private String gender;
    @ApiModelProperty(value = "联系电话")
    private String phone;
    @ApiModelProperty(value = "工作单位代码")
    private String unitCode;
    @ApiModelProperty(value = "工作单位名称")
    private String unit;
    @ApiModelProperty(value = "聘用时间")
    private Date employmentDate;


}
