package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.Getter;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

@Getter
public enum InspectPlanStatusEnum {
    JS_DFP("待分配业务负责人", "66190"),
    JS_YFP_DQR("已分配待确认", "66191"),
    JS_YFP_YQR("已确认", "66192");

    private final String name;

    private final String value;

    InspectPlanStatusEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static InspectPlanStatusEnum getByValue(String value) {
        for (InspectPlanStatusEnum e : InspectPlanStatusEnum.values()) {
            if (e.value.equals(value)) {
                return e;
            }
        }
        throw new BadRequest("not support " + value);
    }
}
