package com.yeejoin.amos.patrol.dao.entity;

import javax.persistence.*;
import java.util.List;


/**
 * The persistent class for the p_plan_task database table.
 * 
 */
@Entity
@Table(name="p_plan_task")
@NamedQuery(name="PlanTask.findAll", query="SELECT p FROM PlanTask p")
public class PlanTask extends BasicEntity {
	private static final long serialVersionUID = 1L;

	/**
	 * 批次号(该字段暂时无效，取值为表id)
	 */
	@Column(name="batch_no")
	private long batchNo;

	/**
	  * 开始时间
	*/
	@Column(name="begin_time")
	private String beginTime;
   /**
    * 巡检日期
    */
	@Column(name="check_date")
	private String checkDate;
	
   /**
    * 结束时间
    */
	@Column(name="end_time")
	private String endTime;
	/**
	 * 已完成数量
	 */
	@Column(name="finish_num")
	private int finishNum;
    /**
     * 完成状态：0-尚未开始；1-正在进行;2-已经结束；3-超时漏检
     */
	@Column(name="finish_status")
	private int finishStatus;
   /**
    * 公司Id
    */
	@Column(name="org_code")
	private String orgCode;
   /**
    * 计划编号
    */
	@Column(name="plan_id")
	private long planId;
	/**
	 * 计划巡检点数
	 */
	@Column(name="point_num")
	private int pointNum;

	/**
	 * 信用代码
	 */
	@Column(name="use_code")
	private String useCode;

	public String getUseCode() {
		return useCode;
	}

	public void setUseCode(String useCode) {
		this.useCode = useCode;
	}

	public String getPlanType() {
		return planType;
	}

	public void setPlanType(String planType) {
		this.planType = planType;
	}

	/**
	 * 计划类型
	 */
	@Column(name="plan_type")
	private String planType;
	
   /**
    * 路线编号
    */
	@Column(name="route_id")
	private long routeId;
	/**
	 * 状态：0-有效；1-无效
	 */
	private int status;

	/**
	 * 状态：0-有效；1-无效
	 */
	@Column(name="risk_status")
	private int riskStatus;

	public int getRiskStatus() {
		return riskStatus;
	}

	public void setRiskStatus(int riskStatus) {
		this.riskStatus = riskStatus;
	}

	/**
    * 可执行人，一个或多个，多个用,隔开 
    */
	@Column(name="user_id")
	private String userId;
	

	
	/**
     * 是否按排序0-否；1-是
     */
	@Column(name="in_order")
	private String inOrder;

	/**
	 * 用户部门
	 */
	@Column(name="user_dept")
	private String userDept;

	/**
	 * 用户姓名
	 */
	@Column(name="user_name")
	private String userName;

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getUserDept() {
		return userDept;
	}

	public void setUserDept(String userDept) {
		this.userDept = userDept;
	}

	/**
	 * 任务点明细
	 */
//	private List<PlanTaskDetail> taskDetail;
	
	public PlanTask() {
	}
	
	public long getBatchNo() {
		return batchNo;
	}

	public void setBatchNo(long batchNo) {
		this.batchNo = batchNo;
	}

	public String getBeginTime() {
		return this.beginTime;
	}

	public void setBeginTime(String beginTime) {
		this.beginTime = beginTime;
	}

	public String getCheckDate() {
		return this.checkDate;
	}

	public void setCheckDate(String checkDate) {
		this.checkDate = checkDate;
	}


	public String getEndTime() {
		return this.endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public int getFinishNum() {
		return this.finishNum;
	}

	public void setFinishNum(int finishNum) {
		this.finishNum = finishNum;
	}

	public int getFinishStatus() {
		return this.finishStatus;
	}

	public void setFinishStatus(int finishStatus) {
		this.finishStatus = finishStatus;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public long getPlanId() {
		return this.planId;
	}

	public void setPlanId(long planId) {
		this.planId = planId;
	}

	public int getPointNum() {
		return this.pointNum;
	}

	public void setPointNum(int pointNum) {
		this.pointNum = pointNum;
	}

	public long getRouteId() {
		return this.routeId;
	}

	public void setRouteId(long routeId) {
		this.routeId = routeId;
	}

	public int getStatus() {
		return this.status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	
//	@OneToMany(mappedBy = "planTask", fetch= FetchType.EAGER, cascade = {CascadeType.REMOVE,CascadeType.MERGE,CascadeType.PERSIST })
//	public List<PlanTaskDetail> getTaskDetail() {
//		return taskDetail;
//	}

	public String getInOrder() {
		return inOrder;
	}

	public void setInOrder(String inOrder) {
		this.inOrder = inOrder;
	}

//	public void setTaskDetail(List<PlanTaskDetail> taskDetail) {
//		this.taskDetail = taskDetail;
//	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}


}