package com.yeejoin.amos.api.openapi.feign;

import com.yeejoin.amos.api.openapi.dto.XiAnElevatorExcelDto;
import com.yeejoin.amos.api.openapi.dto.XiAnEquipInfoExcelDto;
import com.yeejoin.amos.boot.biz.common.feign.FeignConfiguration;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import java.util.Date;
import java.util.List;
import java.util.Map;

@FeignClient(name = "TZS-JG-tb", path = "/jg", configuration = {FeignConfiguration.class})
public interface TzsJgServiceFeignClient {

    /**
     * 根据企业统一信用代码询许可信息
     *
     * @param unitCode 企业唯一编码
     * @return
     */
    @RequestMapping(value = "/baseEnterprise/getUnitLicenceMessage", method = RequestMethod.GET)
    ResponseModel<Object> getLicenceByUnitCode(@RequestParam String unitCode);


    /**
     * 字段列表查询
     *
     * @param dictCode 字段类型
     * @return 列表
     */
    @RequestMapping(value = "/getDataDictionary/{dictCode}", method = RequestMethod.GET)
    ResponseModel<Object> getDataDictionary(@PathVariable String dictCode);

    /**
     * 根据时间范围查询
     *
     * @param equCode   设备代码
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return 电梯数据
     */
    @GetMapping(value = "/equipment-register/getElevatorInfo")
    ResponseModel<Page<Map<String, Object>>> getElevatorInfo(@RequestParam("equCode") String equCode,
                                                             @RequestParam("startTime") @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date startTime,
                                                             @RequestParam("endTime") @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date endTime,
                                                             @RequestParam(value = "current") int current,
                                                             @RequestParam(value = "size") int size
    );

    /**
     * 根据时间范围查询液化石油气瓶档案
     *
     * @param equCode   设备代码
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return 电梯数据
     */
    @GetMapping(value = "/equipment-register/getCylinderInfo")
    ResponseModel<Page<Map<String, Object>>> getCylinderInfo(@RequestParam("equCode") String equCode,
                                                             @RequestParam("startTime") @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date startTime,
                                                             @RequestParam("endTime") @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date endTime,
                                                             @RequestParam(value = "current") int current,
                                                             @RequestParam(value = "size") int size
    );

    /**
     * 查询气站信息
     *
     * @return
     */
    @RequestMapping(value = "/equipment-register/getCylinderStationInfo", method = RequestMethod.GET)
    ResponseModel<List<Map<String, Object>>> getCylinderStationInfo();


    @GetMapping(value = "/equipment-register/getVehicleCylinderInfo")
    ResponseModel<List<Map<String, Object>>> getVehicleCylinderInfo(@RequestParam("useCode") String useCode);


    /**
     * 批量保存西安上传的设备数据
     *
     * @param equipInfoExcelDtos
     * @return
     */
    @RequestMapping(value = "/dataDock/xi-an/saveEquipmentData", method = RequestMethod.POST)
    Object saveEquipmentData(@RequestBody List<XiAnEquipInfoExcelDto> equipInfoExcelDtos);

    /**
     * 设备代码唯一性检查
     *
     * @param equCode
     * @return
     */
    @RequestMapping(value = "/common/checkEquCodeUniqueness", method = RequestMethod.GET)
    Boolean selectByEquCodeAndClaimStatus(@RequestParam("equCode") String equCode);


    /**
     * 车用气瓶业务里面的 出厂编号/产品编码 校验唯一性（产品编号在车用气瓶范围内全局唯一）
     *
     * @param factoryNum
     * @return
     */
    @RequestMapping(value = "/common/checkFactoryNumUniquenessForVehicleCylinder", method = RequestMethod.GET)
    Integer checkFactoryNumUniquenessForVehicleCylinder(@RequestParam("factoryNum") String factoryNum);

    /**
     * 批量保存西安电梯上传的历史数据
     *
     * @param elevatorExcelDtos 西安电梯上传的历史数据
     * @return
     */
    @RequestMapping(value = "/dataDock/xi-an/saveElevatorData", method = RequestMethod.POST)
    Object saveElevatorData(@RequestBody List<XiAnElevatorExcelDto> elevatorExcelDtos);

    /**
     * record唯一性检查
     *
     * @param record
     * @return
     */
    @RequestMapping(value = "/common/checkRecordUniqueness", method = RequestMethod.GET)
    Boolean selectByRecordAndClaimStatus(@RequestParam("record") String record);

    /**
     * 校验气瓶是否合规
     *
     * @param sequenceCodes 待查询气瓶唯一标识集合
     * @return 是否合规数据结果集
     */
    @RequestMapping(value = "/common/cylinderComplianceCheck", method = RequestMethod.POST)
    ResponseModel<List<Map<String, Object>>> cylinderComplianceCheck(@RequestBody List<String> sequenceCodes);
}
