package com.yeejoin.precontrol.controller;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import com.yeejoin.precontrol.common.entity.publics.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.precontrol.common.service.ITaskWorkAttachmentService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.TaskWorkAttachment;
import com.yeejoin.precontrol.common.utils.NameUtils;
import java.lang.reflect.Field;
import java.util.Arrays;


/**
 * 
 *
 * @author duanwei
 * @date 2022-07-07
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/task-work-attachment", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class TaskWorkAttachmentController {

  @Autowired
  ITaskWorkAttachmentService iTaskWorkAttachmentService;


    /**
    * 新增
    * @return
    */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveTaskWorkAttachment(HttpServletRequest request, @RequestBody TaskWorkAttachment taskWorkAttachment){
    return iTaskWorkAttachmentService.save(taskWorkAttachment);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
    return iTaskWorkAttachmentService.removeById(id);
    }




    /**
    * 修改
    * @return
    */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public boolean updateByIdTaskWorkAttachment(HttpServletRequest request, @RequestBody TaskWorkAttachment taskWorkAttachment){
    return iTaskWorkAttachmentService.updateById(taskWorkAttachment);
    }



    /**
   * 根据id查询
   * @param id
   * @return
   */
   @RequestMapping(value = "/{id}", method = RequestMethod.GET)
   @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
   public TaskWorkAttachment selectById(HttpServletRequest request, @PathVariable Long id){
      return iTaskWorkAttachmentService.getById(id);
   }



  /**
  * 列表分页查询
  * @return
  */
  @RequestMapping(value = "/list", method = RequestMethod.GET)
  @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
  public IPage<TaskWorkAttachment> listPage(String pageNum,String pageSize,
    TaskWorkAttachment taskWorkAttachment){

    Page<TaskWorkAttachment> pageBean;
    QueryWrapper<TaskWorkAttachment> taskWorkAttachmentQueryWrapper = new QueryWrapper<>();
    Class<? extends TaskWorkAttachment> aClass = taskWorkAttachment.getClass();
    Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
        try {
            field.setAccessible(true);
            Object o = field.get(taskWorkAttachment);
            if (o != null) {
                Class<?> type = field.getType();
                String name = NameUtils.camel2Underline(field.getName());
                if (type.equals(Integer.class)) {
                Integer fileValue = (Integer) field.get(taskWorkAttachment);
                taskWorkAttachmentQueryWrapper.eq(name, fileValue);
                } else if (type.equals(Long.class)) {
                Long fileValue = (Long) field.get(taskWorkAttachment);
                taskWorkAttachmentQueryWrapper.eq(name, fileValue);
                } else if (type.equals(String.class)) {
                String fileValue = (String) field.get(taskWorkAttachment);
                taskWorkAttachmentQueryWrapper.eq(name, fileValue);
                } else {
                String fileValue = (String) field.get(taskWorkAttachment);
                taskWorkAttachmentQueryWrapper.eq(name, fileValue);
            }
          }
        }catch (Exception e) {
        }
    });
    IPage<TaskWorkAttachment> page;
    if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
        pageBean = new Page<>(0, Long.MAX_VALUE);
    }else{
        pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
    }
    page = iTaskWorkAttachmentService.page(pageBean, taskWorkAttachmentQueryWrapper);
    return page;
  }
}


