package com.yeejoin.amos.boot.module.tzs.flc.api.feign;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@FeignClient(value = "AMOS-IDX", path = "idx")
public interface IdxFeignService {

    @RequestMapping("/dimensionTable/getTreeChildIds")
    ResponseModel<List<String>> getTreeChildIds(@RequestParam String dimensionTableId, @RequestParam String selectValue);

    /**
     * 查询表详情和表字段
     *
     * @param tableId
     * @return
     */
    @RequestMapping(value = "/table/{tableId}", method = RequestMethod.GET)
    ResponseModel<JSONObject> queryByTableId(@PathVariable String tableId);

    /**
     * */
    @RequestMapping(value = "/table/getPage", method = RequestMethod.GET)
    ResponseModel<Page<Map<String,Object>>> getPage(@RequestParam Map map);

    /**
     *根据record查询表格数据详情
     */
    @RequestMapping(value = "/report/form/getFormRecordById", method = RequestMethod.GET)
    ResponseModel<Map<String,Map<String,Object>>>getFormRecordById(@RequestParam Map map);
}
