package com.yeejoin.amos.boot.module.ugp.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
@AllArgsConstructor
public enum ProblemProcessEnum {
    流程开始("流程开始","1","LCKS","","",""),
    确定问题("确定问题","2","QDWT","问题待处理","确定质量问题","待确定"),
    重大问题发送短信("重大问题发送短信","3","ZDWTFSDX","","",""),
    编制处理方案("编制处理方案","4","BZCLFA","问题处理方案待编制","编制处理方案","待编制"),
    审查处理方案("审查处理方案","5","SCCLFA","问题处理方案待审查","审查处理方案","待审查"),
    提交整改书("提交整改书","6","TJZGGC","问题整改书待提交","提交整改书","待提交"),
    审查整改过程("审查整改过程","7","SCZGGC","问题整改书待审查","审查整改过程","待审查"),
    超期整改发送短信("超期整改发送短信","8","CQZGFSDX","问题待处理","",""),
    问题分类("问题分类","9","WTFL","问题待分类","问题分类","待分类"),
    转人工("转人工","10","ZRG","问题已转人工","转人工","等待人工处理"),
    结束("流程结束！","11","JS","问题已处理","",""),
    重大问题整改完成发送短信("重大问题整改完成发送短信","12","ZDWTZGWCFSDX","问题已处理","","");

    private String Name;
    private String key;
    private String Code;
    private String progress;
    private String taskName;
    private String taskStatus;


    public static Map<String,String> map = new HashMap<>();
    public static Map<String,String> statusMap = new HashMap<>();
    public static Map<String,String> getTaskStatusMap = new HashMap<String, String>();
    public static Map<String,String> getTaskNameMap = new HashMap<String, String>();

    static {
        for (ProblemProcessEnum proBlemProcessEnum : ProblemProcessEnum.values()) {
            map.put(proBlemProcessEnum.getCode(),proBlemProcessEnum.getName());
            statusMap.put(proBlemProcessEnum.getName(),proBlemProcessEnum.getProgress());
            getTaskStatusMap.put(proBlemProcessEnum.getName(),proBlemProcessEnum.getTaskStatus());
            getTaskNameMap.put(proBlemProcessEnum.getName(),proBlemProcessEnum.getTaskName());
        }
    }
}
