package com.yeejoin.amos.boot.module.ugp.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 安装告知表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="InstallNoticeDto", description="安装告知表")
public class InstallNoticeDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "告知申请提交日期")
    private Date noticeDate;

    @ApiModelProperty(value = "告知申请状态")
    private String noticeStatus;

    @ApiModelProperty(value = "组织机构代码")
    private String organizationCode;

    @ApiModelProperty(value = "许可单位名称")
    private String licenseCompany;

    @ApiModelProperty(value = "许可证编号")
    private String licenseNum;

    @ApiModelProperty(value = "许可单位id")
    private Long licenseCompanyId;

    @ApiModelProperty(value = "合同文件")
    private String contractAttch;

    @ApiModelProperty(value = "许可证文件")
    private String licenseAttch;

    @ApiModelProperty(value = "是否审批通过（1通过，0未通过）")
    private Boolean approved;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "安装负责人")
    private String installPri;

    private String projectName;

    private String companyName;

    /**
     * 设备名称
     */
    @ApiModelProperty("设备名称")
    private String equipName;
    /**
     * 设备代码
     */
    @ApiModelProperty("设备代码")
    private String equipCode;
    /**
     * 制造编号
     */
    @ApiModelProperty("制造编号")
    private String factoryNum;
    /**
     * 设备地点
     */
    @ApiModelProperty("设备地点")
    private String equipPosition;
    /**
     * 安装改造维修日期
     */
    @ApiModelProperty("安装改造维修日期")
    private Date implementDate;
    /**
     * 施工单位
     */
    @ApiModelProperty("施工单位")
    private String constructionUnit;
    /**
     * 施工类别
     */
    @ApiModelProperty("施工类别")
    private String constructionType;
    /**
     * 联系人
     */
    @ApiModelProperty("联系人")
    private String contact;
    /**
     * 电话
     */
    @ApiModelProperty("电话")
    private String phone;
    /**
     * 传真
     */
    @ApiModelProperty("传真")
    private String fax;
    /**
     * 邮编
     */
    @ApiModelProperty("邮编")
    private String zipcode;
    /**
     * 地址
     */
    @ApiModelProperty("地址")
    private String address;
    /**
     * 使用单位联系人
     */
    @ApiModelProperty("使用单位联系人")
    private String useUnitContact;
    /**
     * 使用单位电话
     */
    @ApiModelProperty("使用单位电话")
    private String useUnitPhone;
    /**
     * 使用单位传真
     */
    @ApiModelProperty("使用单位传真")
    private String useUnitFax;
    /**
     * 使用单位邮编
     */
    @ApiModelProperty("使用单位邮编")
    private String useUnitZipcode;
    /**
     * 使用单位地址
     */
    @ApiModelProperty("使用单位地址")
    private String useUnitAddress;

    //以下字段为页面需要回显字段，不需要提交入库的字段
    /**
     * 设备型号(参数)
     */
    @ApiModelProperty("设备型号(参数)")
    private String equipType;

    @ApiModelProperty("制造单位")
    private String madeUnit;

    @ApiModelProperty("制造许可证编号")
    private String madeLicenceCode;

    @ApiModelProperty("施工单位许可证编号")
    private String buildLicenceCode;

    @ApiModelProperty("施工单位许可证有效期")
    private String buildLicenceDateLine;

    @ApiModelProperty("使用单位")
    private String useUnitName;

    @ApiModelProperty("流程实例ID")
    private String instanceId;

    @ApiModelProperty("审核意见")
    private String auditOpinion;


     private String projectCode;
     private String install;
     private String design;
}
