package com.yeejoin.amos.boot.module.common.biz.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;

import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.module.common.api.dto.DutyFirstAidDto;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.api.mapper.DutyPersonShiftMapper;
import com.yeejoin.amos.boot.module.common.api.service.IDutyFirstAidService;

@Service
public class DutyFirstAidServiceImpl extends DutyCommonServiceImpl implements IDutyFirstAidService {


	@Autowired
	DutyPersonShiftMapper dutyPersonShiftMapper;

	@Autowired
	OrgUsrServiceImpl orgUsrServiceImpl;
	
	@Autowired
	DataDictionaryServiceImpl dataDictionaryService;

	public String getGroupCode() {
		return "dutyFirstAid";
	}

	@Override
	public DutyFirstAidDto save(DutyFirstAidDto dto) {
		Map<String, Object> fireStationDtoResult = dutyPersonShiftMapper.getFireTeamBySequenceNbr(Long.parseLong(dto.getFirstAidId()));
		if(fireStationDtoResult==null || !fireStationDtoResult.containsKey("name")) {
			throw new RuntimeException("此120急救站不存在");
		}
		dto.setFirstAid(fireStationDtoResult.get("name").toString());
		Map<String, Object> map = Bean.BeantoMap(dto);
		Long instanceId = excuteDynamicFormInstance(dto.getUserId(), map, this.getGroupCode());
		saveDutyPersonShiftDetail(instanceId, dto.getDutyShift(), dto.getStartTime());
		insertPersonShift(instanceId, dto.getDutyShift());
		return dto;
	}

	@Override
	public DutyFirstAidDto update(Long instanceId, DutyFirstAidDto dto) {
		updateDynamicFormInstance(this.getGroupCode(), instanceId, Bean.BeantoMap(dto));
		insertPersonShift(instanceId, dto.getDutyShift());
		return dto;
	}

	@Override
	public Object getSchedulingDutyForSpecifyDate(String dutyDay, Long shiftId, String postType) {
		List<Map<String, Object>> equipmentList = dutyPersonShiftMapper.getEquipmentForSpecifyDate(dutyDay,
				this.getGroupCode(), "firstAidId", "firstAid", "teamName", "result.firstAidId");
		if (equipmentList == null || equipmentList.size() < 1 || equipmentList.get(0) == null) {
			return null;
		}
		List<Object> detailList = new ArrayList<Object>();
		for (Map<String, Object> map : equipmentList) {
			List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
			LinkedHashMap<String, Object> titleMap_1 = new LinkedHashMap<String, Object>();
			titleMap_1.put("120急救站", map.get("firstAid").toString());
			resultList.add(titleMap_1);
			LinkedHashMap<String, Object> titleMap_2 = new LinkedHashMap<String, Object>();
			titleMap_2.put("单位/部门", map.get("teamName").toString());
			resultList.add(titleMap_2);
			String carId = map.get("firstAidId").toString();
			Map<String, Object> instanceMap = dutyPersonShiftMapper.getInstanceIdForSpecifyDateAndEquipment(dutyDay,
					this.getGroupCode(), carId);
			if (instanceMap == null) {
				continue;
			}
			String instanceId = instanceMap.get("instanceIds").toString();
			if (StringUtils.isNotBlank(instanceId)) {
				String[] instanceIds = instanceId.split(",");

				List<Map<String, Object>> dutyList = dutyPersonShiftMapper.getDutyForSpecifyDate(dutyDay);
				if (dutyList != null && dutyList.size() > 0) {
					for (Map<String, Object> dutyDetail : dutyList) {
						if (!dutyDetail.containsKey("name")) {
							continue;
						}
						// 获取当前装备ID下的排版数据
						List<Map<String, Object>> specifyDateList = dutyPersonShiftMapper
								.getPositionStaffDutyForSpecifyDate(dutyDay, this.getGroupCode(), instanceIds,
										dutyDetail.get("name").toString());
						if (specifyDateList == null || specifyDateList.size() < 1 || specifyDateList.get(0) == null) {
							continue;
						}
						LinkedHashMap<String, Object> infoMap_1 = new LinkedHashMap<String, Object>();
						infoMap_1.put(dutyDetail.get("name").toString(), "");
						resultList.add(infoMap_1);
						for (Map<String, Object> specify : specifyDateList) {
							LinkedHashMap<String, Object> infoMap_2 = new LinkedHashMap<String, Object>();
							infoMap_2.put(specify.get("postTypeName").toString(), specify.get("userName").toString());
							resultList.add(infoMap_2);
						}
					}
				}
			}
			detailList.add(resultList);
		}
		return detailList;
	}

	public List< Map<String, Object>> getFirstAidExportData(List<String> ids) {
		List< Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
		String typeString = "DUTY_POST_TYPE";
		ids.stream().forEach(i->{
			Map<String, Object> detailMap = new HashMap<String, Object>();
			List<OrgUsr> personList = orgUsrServiceImpl.getPersonListByParentId(Long.parseLong(i));
			List<String> userNameList= new ArrayList<String>();
			personList.stream().forEach(m -> {
				String userNameString =m.getBizOrgName()+ "@" +m.getSequenceNbr();
				userNameList.add(userNameString);
			});
			detailMap.put("userName", userNameList);
			OrgUsr companyDetail =	orgUsrServiceImpl.getDetailById(Long.parseLong(i));
			String companyNameString = companyDetail.getBizOrgName()+ "@" +companyDetail.getSequenceNbr();
			detailMap.put("companyName", companyNameString);
			List<DataDictionary>  dataDicList=	dataDictionaryService.getByType(typeString);
			List<String> dataDicSimpleList = new ArrayList<String>();
			dataDicList.stream().forEach(l->{
				String dataDic = l.getName() + "@" +l.getCode();
				dataDicSimpleList.add(dataDic);
			});
			detailMap.put("postTypeName",dataDicSimpleList);
			List<Map<String, Object>> list = dutyPersonShiftMapper.getFirstAidForTypeCodeAndCompanyId(
					Long.parseLong(i));
			
			List<String> firstAidSimpleList = new ArrayList<String>();
			list.stream().forEach(m -> {
				String firstAidNameString = m.get("name").toString() + "@" + m.get("sequence_nbr").toString();
				firstAidSimpleList.add(firstAidNameString);
			});
			detailMap.put("firstAidName", firstAidSimpleList);
			resultList.add(detailMap);
		});
		return resultList;
	}

}
