package com.yeejoin.equipmanage.common.enums;

public enum PressurePumpMessageEnum {

    MESSAGE_LEVEL_YB("YB", "【%s】分钟内，启停间隔较小",  "","名称：稳压泵启停异常提醒；时间：%s；内容：【%s】- 【%s】 -  【%s】分钟内，设备启停频繁，请及时查看处理"),
    MESSAGE_LEVEL_YZ("YZ", "【%s】分钟内，启停间隔较小", "", "名称：稳压泵启停异常提醒；时间：%s；内容：【%s】- 【%s】 -  【%s】分钟内，设备启停频繁，请及时查看处理"),
    MESSAGE_LEVEL_QT_WJ("QT_WJ", "【%s】分钟内，设备启停频繁", "", "名称：漏水提醒； 时间：%s；内容：【%s】- 【%s】 - 【%s】分钟内，设备启停频繁，可能存在漏水，请及时查看处理"),
    MESSAGE_LEVEL_QT_WJ_YXSC("WJ_YXSC", "运行时长超过【%s】分钟，存在漏水可能", "", "名称：漏水提醒； 时间：%s；内容：【%s】- 【%s】 - 运行时长超过【%s】分钟，存在漏水可能，请及时查看处理");
    private String code;
    private String allMessage;
    private String marqueeMessage;
    private String recordMessage;

    private PressurePumpMessageEnum(String code, String allMessage, String marqueeMessage,String recordMessage) {
        this.code = code;
        this.allMessage = allMessage;
        this.marqueeMessage = marqueeMessage;
        this.recordMessage = recordMessage;
    }

    public String getCode() {
        return code;
    }
    public String getAllMessage() {
        return allMessage;
    }
    public String getMarqueeMessage() {
        return marqueeMessage;
    }
    public String getRecordMessage() {
        return recordMessage;
    }


    public static PressurePumpMessageEnum getByCode(String code) {
        for (PressurePumpMessageEnum l : PressurePumpMessageEnum.values()) {
            if (code.equals(l.getCode())) {
                return l;
            }
        }
        return null;
    }
}
