package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.yeejoin.amos.boot.module.common.api.service.IFirefightersService;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@Api(tags = "一张图大屏Api")
@RequestMapping(value = "/bigScreen")
public class BigScreenController {

    @Autowired
    private IFirefightersService iFirefightersService;

    @GetMapping(value = "/getFireForceInfoByCode")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "消防车、消防力量信息（专职消防队、运维人员）、人员出勤", notes = "消防车、消防力量信息（专职消防队、运维人员、人员出勤）")
    public ResponseModel getFireForceInfoByCode(@RequestParam(required = false, value = "companyCode") String companyCode) {
        return CommonResponseUtil.success(iFirefightersService.getFireForceInfoByCode(companyCode));
    }
}
