package com.yeejoin.amos.latentdanger.business.vo;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.latentdanger.business.entity.mybatis.extend.LatentDangerFlowRecordBo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.checkerframework.checker.units.qual.A;

import java.util.Date;
import java.util.List;

/**
 * @author DELL
 */
@Data
public class LatentDangerDetailVo {

    @ApiModelProperty(value = "隐患主键")
    private Long id;

    @ApiModelProperty(value = "隐患编号")
    private String businessKey;

    @ApiModelProperty(value = "隐患名称")
    private String dangerName;

    @ApiModelProperty(value = "业务id")
    private Long bizId;

    @ApiModelProperty(value = "隐患等级")
    private String dangerLevel;

    @ApiModelProperty(value = "隐患等级名称")
    private String dangerLevelName;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "隐患地点")
    private String dangerPosition;

    @ApiModelProperty(value = "整改类型")
    private String reformTypeName;

    @ApiModelProperty(value = "整改限制时间")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date reformLimitDate;

    @ApiModelProperty(value = "整改对象")
    private JSONObject reformJson;

    @ApiModelProperty(value = "当前流程节点记录id")
    private Long currentFlowRecordId;

    @ApiModelProperty(value = "隐患状态名称")
    private String dangerState;

    @ApiModelProperty(value = "隐患状态名称")
    private String dangerStateName;

    private String dangerType;

    private String dangerTypeName;

    @ApiModelProperty(value = "检查类型")
    private String checkMode;

    public String getCheckMode() {
        return this.dangerType;
    }

    @ApiModelProperty(value = "检查类型名称")
    private String checkModeName;

    public String getCheckModeName() {
        return this.dangerTypeName;
    }

    private Boolean currentUserCanExecute;

    @ApiModelProperty(value = "隐患图片信息")
    private List<String> photoUrl;

    private LatentDangerDetailRiskVo riskInfo;

    @ApiModelProperty(value = "复审信息")
    private JSONObject reviewInfo;

    @ApiModelProperty(value = "整改信息")
    private JSONObject reformInfo;

    @ApiModelProperty(value = "复查信息")
    private JSONObject recheckInfo;

    @ApiModelProperty(value = "流程信息")
    private List<LatentDangerFlowRecordBo> records;

    private Date delayLimitDate;

    private String problemDescription;

    private String reasonAnalysis;

    private String inferOtherThings;

    private String taskId;

    @ApiModelProperty(value = "业务信息")
    private JSONObject bizInfo;

    @ApiModelProperty(value = "提交时间")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createDate;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "审核信息")
    private JSONObject flowJson;
}
