package com.yeejoin.amos.boot.module.tzs.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.module.tzs.api.dto.EquEnterDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.PageParam;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzBaseEnterpriseInfo;

import java.util.List;

/**
 * 企业数据信息 服务类
 *
 * @author duanwei
 * @date 2022-08-10
 */
public interface ITzBaseEnterpriseInfoService extends IService<TzBaseEnterpriseInfo> {

	/**
	 * 查找企业关联设备详情列表
	 * 
	 * @param sequenceNbr 企业id
	 * @return EquEnterDto 使用登记证代码、设备名称、设备类别、设备位置
	 */
	List<EquEnterDto> getInfo(String sequenceNbr);

	IPage<TzBaseEnterpriseInfoDto> page(PageParam pageParam, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto);

	TzBaseEnterpriseInfoDto detail(Long id);

	List<EquEnterDto> getInfoByUseUnit(String useUnit);

	TzBaseEnterpriseInfoDto selectByUseUnit(String useUnit);
}
