package com.yeejoin.equipmanage.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 类型枚举
 * @author DELL
 */
@Getter
@AllArgsConstructor
public enum EmergencyLevelEum {

    JJ("1", "紧急"),
    YZ("2", "严重"),
    QW("3", "轻微"),
    ZC("4", "正常");

    private String code;

    private String name;

    public static List<String> getDropDownList() {
        List<String> list = new ArrayList<>();
        for(EmergencyLevelEum eum : EmergencyLevelEum.values()) {
            String str = eum.getName() + "@" + eum.getCode();
            list.add(str);
        }
        return list;
    }

    public static String getNameByCode(String code) {
        String str = "";
        if (StringUtils.isNotEmpty(code)) {
            for(EmergencyLevelEum eum : EmergencyLevelEum.values()) {
                if (code.equalsIgnoreCase(eum.getCode())) {
                    str = eum.getName();
                    break;
                }
            }
        }
        return str;
    }

    public static String getCodeByName(String name) {
        String str = "";
        if (StringUtils.isNotEmpty(name)) {
            for(EmergencyLevelEum eum : EmergencyLevelEum.values()) {
                if (name.equalsIgnoreCase(eum.getName())) {
                    str = eum.getName();
                    break;
                }
            }
        }
        return str;
    }

}
