package com.yeejoin.equipmanage.common.utils;

import com.yeejoin.equipmanage.common.entity.EquipmentSpecificIndex;
import com.yeejoin.equipmanage.common.entity.vo.StateVo;
import com.yeejoin.equipmanage.common.enums.AlarmStatusEnum;
import com.yeejoin.equipmanage.common.enums.EquipmentRiskTypeEnum;
import com.yeejoin.equipmanage.common.enums.EquipmentStateEnum;
import com.yeejoin.equipmanage.common.enums.TrueOrFalseEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @title: EquipmentStateUtil
 * <pre>
 * @description: 通过性能指标判断设备状态（火灾报警 > 故障告警 > 屏蔽 > 运行状态）
 * </pre>
 * @date 2021/1/8 09:32
 */
public class EquipmentStateUtil {
    private EquipmentStateUtil() {
    }

    private final static Logger log = LoggerFactory.getLogger(EquipmentStateUtil.class);

    public static String judgeState(List<EquipmentSpecificIndex> indexList) {
        StateVo stateVo = new StateVo();
        for (EquipmentSpecificIndex equipmentSpecificIndex : indexList) {
            String keyValue = String.valueOf(equipmentSpecificIndex.getValue());
            if (EquipmentRiskTypeEnum.HZGJ.getCode().equals(equipmentSpecificIndex.getTypeCode())) {
                if (TrueOrFalseEnum.real.value.equals(keyValue)) {
                    stateVo.setAlarm(TrueOrFalseEnum.real.value);
                } else {
                    stateVo.setAlarm(TrueOrFalseEnum.fake.value);
                }
            }
            if (EquipmentRiskTypeEnum.GZ.getCode().equals(equipmentSpecificIndex.getTypeCode())) {
                if (TrueOrFalseEnum.real.value.equals(keyValue)) {
                    stateVo.setFault(TrueOrFalseEnum.real.value);
                } else {
                    stateVo.setFault(TrueOrFalseEnum.fake.value);
                }
            }
            if (EquipmentRiskTypeEnum.PB.getCode().equals(equipmentSpecificIndex.getTypeCode())) {
                if (TrueOrFalseEnum.real.value.equals(keyValue)) {
                    stateVo.setShield(TrueOrFalseEnum.real.value);
                } else {
                    stateVo.setShield(TrueOrFalseEnum.fake.value);
                }
            }
            if (EquipmentRiskTypeEnum.YXZT.getCode().equals(equipmentSpecificIndex.getTypeCode())) {
                if (TrueOrFalseEnum.real.value.equals(keyValue)) {
                    stateVo.setRunState(TrueOrFalseEnum.real.value);
                } else {
                    stateVo.setRunState(TrueOrFalseEnum.fake.value);
                }
            }
        }
        String status = getStatus(stateVo);
        log.info("此装备的状态为(屏蔽-5, 火灾告警-4, 故障-3, 正常-2, 挂起-1)： " );
        return status;
    }

    private static String getStatus(StateVo stateVo) {
        String status = EquipmentStateEnum.ZC.getStatus();
        if (StringUtil.isNotEmpty(stateVo.getAlarm()) && TrueOrFalseEnum.real.value.equals(stateVo.getAlarm())) {
            status = EquipmentStateEnum.HZGJ.getStatus();
            return status;
        } else {
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.real.value.equals(stateVo.getFault())
                    && TrueOrFalseEnum.real.value.equals(stateVo.getShield()) && TrueOrFalseEnum.real.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.GZ.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.real.value.equals(stateVo.getFault())
                    && TrueOrFalseEnum.fake.value.equals(stateVo.getShield()) && TrueOrFalseEnum.real.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.GZ.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.real.value.equals(stateVo.getFault())
                    && TrueOrFalseEnum.real.value.equals(stateVo.getShield()) && TrueOrFalseEnum.fake.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.GZ.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.real.value.equals(stateVo.getFault())
                    && TrueOrFalseEnum.fake.value.equals(stateVo.getShield()) && TrueOrFalseEnum.fake.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.GZ.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.fake.value.equals(stateVo.getFault())
                    && TrueOrFalseEnum.real.value.equals(stateVo.getShield()) && TrueOrFalseEnum.real.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.PB.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.fake.value.equals(stateVo.getFault())
                    && TrueOrFalseEnum.fake.value.equals(stateVo.getShield()) && TrueOrFalseEnum.fake.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.STOP.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.fake.value.equals(stateVo.getFault())
                    && TrueOrFalseEnum.real.value.equals(stateVo.getShield()) && TrueOrFalseEnum.fake.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.PB.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.fake.value.equals(stateVo.getFault())
                    && TrueOrFalseEnum.fake.value.equals(stateVo.getShield()) && TrueOrFalseEnum.real.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.ZC.getStatus();
                return status;
            }

            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.real.value.equals(stateVo.getFault()) && TrueOrFalseEnum.real.value.equals(stateVo.getShield())) {
                status = EquipmentStateEnum.GZ.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.real.value.equals(stateVo.getFault()) && TrueOrFalseEnum.fake.value.equals(stateVo.getShield())) {
                status = EquipmentStateEnum.GZ.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.fake.value.equals(stateVo.getFault()) && TrueOrFalseEnum.real.value.equals(stateVo.getShield())) {
                status = EquipmentStateEnum.PB.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.fake.value.equals(stateVo.getFault()) && TrueOrFalseEnum.fake.value.equals(stateVo.getShield())) {
                status = EquipmentStateEnum.ZC.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.real.value.equals(stateVo.getFault()) && TrueOrFalseEnum.real.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.GZ.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.real.value.equals(stateVo.getFault()) && TrueOrFalseEnum.fake.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.GZ.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.fake.value.equals(stateVo.getFault()) && TrueOrFalseEnum.real.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.ZC.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.fake.value.equals(stateVo.getFault()) && TrueOrFalseEnum.fake.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.STOP.getStatus();
                return status;
            }

            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.fake.value.equals(stateVo.getFault())) {
                status = EquipmentStateEnum.ZC.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.real.value.equals(stateVo.getFault())) {
                status = EquipmentStateEnum.STOP.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.fake.value.equals(stateVo.getShield())) {
                status = EquipmentStateEnum.ZC.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.real.value.equals(stateVo.getShield())) {
                status = EquipmentStateEnum.PB.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.fake.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.STOP.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm()) && TrueOrFalseEnum.real.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.ZC.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getFault()) && TrueOrFalseEnum.fake.value.equals(stateVo.getShield())) {
                status = EquipmentStateEnum.ZC.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getFault()) && TrueOrFalseEnum.real.value.equals(stateVo.getShield())) {
                status = EquipmentStateEnum.PB.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getFault()) && TrueOrFalseEnum.fake.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.STOP.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getFault()) && TrueOrFalseEnum.real.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.ZC.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.real.value.equals(stateVo.getFault()) && TrueOrFalseEnum.fake.value.equals(stateVo.getShield())) {
                status = EquipmentStateEnum.GZ.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.real.value.equals(stateVo.getFault()) && TrueOrFalseEnum.real.value.equals(stateVo.getShield())) {
                status = EquipmentStateEnum.GZ.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.real.value.equals(stateVo.getFault()) && TrueOrFalseEnum.fake.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.GZ.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.real.value.equals(stateVo.getFault()) && TrueOrFalseEnum.real.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.GZ.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getShield()) && TrueOrFalseEnum.fake.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.STOP.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getShield()) && TrueOrFalseEnum.real.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.ZC.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.real.value.equals(stateVo.getShield()) && TrueOrFalseEnum.fake.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.PB.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.real.value.equals(stateVo.getShield()) && TrueOrFalseEnum.real.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.PB.getStatus();
                return status;
            }

            if (TrueOrFalseEnum.fake.value.equals(stateVo.getAlarm())) {
                status = EquipmentStateEnum.ZC.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.real.value.equals(stateVo.getFault())) {
                status = EquipmentStateEnum.GZ.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getFault())) {
                status = EquipmentStateEnum.ZC.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.real.value.equals(stateVo.getShield())) {
                status = EquipmentStateEnum.PB.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getShield())) {
                status = EquipmentStateEnum.ZC.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.real.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.ZC.getStatus();
                return status;
            }
            if (TrueOrFalseEnum.fake.value.equals(stateVo.getRunState())) {
                status = EquipmentStateEnum.STOP.getStatus();
                return status;
            }
        }
        return status;
    }

    public static String judgeEquipState(List<EquipmentSpecificIndex> indexList) {
        String status = EquipmentStateEnum.ZC.getStatus();
        EquipmentSpecificIndex index = indexList.stream().filter(x -> x.getUpdateDate() != null).sorted(Comparator.comparing(EquipmentSpecificIndex::getUpdateDate).reversed()).collect(Collectors.toList()).get(0);
        String keyValue = String.valueOf(index.getValue());
        for (EquipmentRiskTypeEnum enums : EquipmentRiskTypeEnum.values()) {
            if (enums.getCode().equals(index.getTypeCode()) && TrueOrFalseEnum.real.value.equals(keyValue)) {
                status = enums.getStateCode();
                break;
            }
        }
        log.info("此装备状态为(屏蔽-5, 火灾告警-4, 故障-3, 正常-2, 挂起-1)：" );
        return status;
    }
    
    public static String judgeEquipState(EquipmentSpecificIndex index) {
        if (TrueOrFalseEnum.real.value.equalsIgnoreCase(String.valueOf(index.getValue()))) {
            return AlarmStatusEnum.BJ.getCode() == index.getIsAlarm() ? index.getEmergencyLevelColor() : "";
        }
        return "";
    }
}
