package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.*;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentIndexVO;
import com.yeejoin.equipmanage.mapper.EquipmentIndexMapper;
import com.yeejoin.equipmanage.mapper.SignalClassifyMapper;
import com.yeejoin.equipmanage.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@Service
public class EquipmentIndexImpl extends ServiceImpl<EquipmentIndexMapper, EquipmentIndex> implements IEquipmentIndexService {
    @Autowired
    @Lazy
    ICarService iCarService;

    @Autowired
    ICarPropertyService iCarPropertyService;

    @Autowired
    IEquipmentDetailService iEquipmentDetailService;

    @Autowired
    IEquPropertyService iEquPropertyService;

    @Autowired
    @Lazy
    IEquipmentSpecificSerivce iEquipmentSpecificSerivce;

    @Autowired
    IEquipmentSpecificIndexSerivce iEquipmentSpecificIndexSerivce;

    @Autowired
    SignalClassifyMapper signalClassifyMapper;

    @Override
    public IPage<EquipmentIndexVO> getPerfQutoaPage(IPage<EquipmentIndex> page, Long id, String groupName) {
        return this.baseMapper.getPage(page, id, groupName);
    }

    @Override
    public List<EquipmentIndexVO> getPerfQutoaList(Long id) {
        return this.baseMapper.getPerfQutoaList(id);
    }

    @Override
    public int checkUnit(List<String> ids) {
        for (String id : ids) {
            int count = this.baseMapper.checkUnit(id);
            if (count > 0) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public List<EquipmentIndexVO> getEquipmentIndexByIot() {
        return this.baseMapper.getEquipmentIndexByIot();
    }

    @Override
    public List<String> getGruopName(Long equipmentId) {
        return this.baseMapper.getGruopName(equipmentId);
    }

    @Override
    public List<EquipmentIndex> getPerfQutoaIotList(Long id) {
        return this.baseMapper.getPerfQutoaIotList(id);
    }

    @Override
    public EquipmentIndexVO getOnePrefQuota(Long id) {
        return this.baseMapper.getOnePrefQuota(id);
    }

    @Override
    public String checkName(Long id, Long dataId, Long fId) {
        int s = this.baseMapper.checkName(id, dataId, fId);
        if (s == 0) {
            return "";
        } else {
            return "性能指标名称重复";
        }
    }

    @Override
    public void updateE(Long id) {
        this.baseMapper.updateE(id);
    }

    @Override
    public boolean savePerfQuota(EquipmentIndex equipmentIndex) {
        AtomicBoolean bool = new AtomicBoolean(true);
        if (ValidationUtil.isEmpty(equipmentIndex.getTypeCode())) {
            bool.set(false);
        }
        SignalClassify signalClassify = null;
        if (bool.get()) {
            LambdaQueryWrapper<SignalClassify> queryWrapper = new LambdaQueryWrapper();
            queryWrapper.inSql(SignalClassify::getTypeCode,
                    "SELECT type_code FROM wl_signal_classify WHERE UPPER(type_code) ='" + equipmentIndex.getTypeCode().toUpperCase() +"'");
            signalClassify = signalClassifyMapper.selectOne(queryWrapper);
            equipmentIndex.setEmergencyLevelColor(signalClassify.getEmergencyLevelColor());
            equipmentIndex.setIsAlarm(signalClassify.getIsAlarm());
            equipmentIndex.setEmergencyLevel(signalClassify.getEmergencyLevel());
            equipmentIndex.setEmergencyLevelDescribe(signalClassify.getEmergencyLevelDescribe());
        }
        int i = this.baseMapper.insert(equipmentIndex);
        QueryWrapper<EquipmentDetail> equipmentDetailQueryWrapper = new QueryWrapper<>();
        equipmentDetailQueryWrapper.eq("equipment_id", equipmentIndex.getEquipmentId());
        List<EquipmentDetail> equipDetailList = iEquipmentDetailService.list(equipmentDetailQueryWrapper);
        if (ObjectUtils.isEmpty(equipDetailList)) {
            QueryWrapper<Car> carQueryWrapper = new QueryWrapper<>();
            carQueryWrapper.eq("equipment_id", equipmentIndex.getEquipmentId());
            List<Car> carList = iCarService.list(carQueryWrapper);
            if (!ObjectUtils.isEmpty(carList)) {
                List<CarProperty> carProperties = new ArrayList<>();
                for (Car car : carList) {
                    CarProperty carProperty = new CarProperty();
                    carProperty.setCarId(car.getId());
                    carProperty.setEquipmentIndexId(equipmentIndex.getId());
                    carProperty.setEquipmentIndexKey(equipmentIndex.getPerfQuotaDefinitionId());
                    carProperty.setEquipmentIndexName(equipmentIndex.getPerfQuotaName());
                    if (bool.get() && null != signalClassify) {
                        carProperty.setEmergencyLevelColor(signalClassify.getEmergencyLevelColor());
                        carProperty.setIsAlarm(signalClassify.getIsAlarm());
                        carProperty.setEmergencyLevel(signalClassify.getEmergencyLevel());
                        carProperty.setEmergencyLevelDescribe(signalClassify.getEmergencyLevelDescribe());
                    }
                    carProperties.add(carProperty);
                }
                iCarPropertyService.saveBatch(carProperties);
            }
        } else {
            List<Long> uipmentDetailIds = new ArrayList<>();
            equipDetailList.forEach(x -> {
                uipmentDetailIds.add(x.getId());
            });
            QueryWrapper<EquipmentSpecific> equipmentSpecificQueryWrapper = new QueryWrapper<>();
            equipmentSpecificQueryWrapper.in("equipment_detail_id", uipmentDetailIds);
            List<EquipmentSpecific> equipmentSpecifics = iEquipmentSpecificSerivce.list(equipmentSpecificQueryWrapper);
            if (equipmentSpecifics.size() > 0) {
                List<EquipmentSpecificIndex> equipmentSpecificIndexList = new ArrayList<>();
                for (EquipmentSpecific y : equipmentSpecifics) {
                    EquipmentSpecificIndex equipmentSpecificIndex = new EquipmentSpecificIndex();
                    equipmentSpecificIndex.setEquipmentSpecificId(y.getId());
                    equipmentSpecificIndex.setEquipmentIndexId(equipmentIndex.getId());
                    equipmentSpecificIndex.setEquipmentIndexKey(equipmentIndex.getPerfQuotaDefinitionId());
                    equipmentSpecificIndex.setEquipmentIndexName(equipmentIndex.getPerfQuotaName());
                    equipmentSpecificIndex.setEquipmentSpecificName(y.getName());
                    if (bool.get() && null != signalClassify) {
                        equipmentSpecificIndex.setEmergencyLevelColor(signalClassify.getEmergencyLevelColor());
                        equipmentSpecificIndex.setIsAlarm(signalClassify.getIsAlarm());
                        equipmentSpecificIndex.setEmergencyLevel(signalClassify.getEmergencyLevel());
                        equipmentSpecificIndex.setEmergencyLevelDescribe(signalClassify.getEmergencyLevelDescribe());
                    }
                    equipmentSpecificIndexList.add(equipmentSpecificIndex);
                };
                iEquipmentSpecificIndexSerivce.saveBatch(equipmentSpecificIndexList);
            }
        }

        if (i == 0) {
            return false;
        }
//        synchronizationIndex(equipmentIndex);
        return true;
    }
//    @Async
//    private void synchronizationIndex(EquipmentIndex equipmentIndex){
//    	QueryWrapper carQw = new QueryWrapper();
//        carQw.eq("equipmentId", equipmentIndex.getEquipmentId());
//        List<Car> carList = iCarService.list(carQw);
//        List<CarProperty> cpList = new ArrayList<CarProperty>();
//        if(ObjectUtils.isArray(carList)){
//        	carList.forEach(action->{
//        		CarProperty cp = new CarProperty();
//        		cp.setCarId(action.getId());
//        		cp.setEquipmentIndexId(equipmentIndex.getId());
//        		cp.setValue("");
//        		cpList.add(cp);
//        	});
//        	iCarPropertyService.saveBatch(cpList);
//        }
//        QueryWrapper edQw = new QueryWrapper();
//        carQw.eq("equipmentId", equipmentIndex.getEquipmentId());
//        List<EquipmentDetail> eqList = iEquipmentDetailService.list(carQw);
//        List<EquProperty> eqpList = new ArrayList<EquProperty>();
//        List<EquipmentSpecificIndex> eqSpList = new ArrayList<EquipmentSpecificIndex>();
//        if (ObjectUtils.isArray(eqList)) {
//        	for(EquipmentDetail eq:eqList){
//        		EquProperty eqp = new EquProperty();
//        		eqp.setEquipmentDetailId(eq.getId());
//        		eqp.setEquipmentIndexId(equipmentIndex.getId());
//        		eqp.setValue("");
//        		eqpList.add(eqp);
//        		QueryWrapper eqSQw = new QueryWrapper();
//        		eqSQw.eq("equipmentDetailId", eq.getId());
//    	        List<EquipmentSpecific> eqSList = iEquipmentSpecificSerivce.list(eqSQw);
//    	        for(EquipmentSpecific eqs:eqSList){
//    	        	EquipmentSpecificIndex eqsp = new EquipmentSpecificIndex();
//    	        	eqsp.setEquipmentSpecificId(eqs.getId());
//    	        	eqsp.setValue("");
//    	        	eqsp.setEquipmentIndexId(equipmentIndex.getId());
//    	        	eqSpList.add(eqsp);
//    	        }
//        	}
//        	iEquPropertyService.saveBatch(eqpList);
//        	iEquipmentSpecificIndexSerivce.saveBatch(eqSpList);
//		}
//    }
}
