package com.yeejoin.amos.supervision.business.service.intfc;

import com.yeejoin.amos.supervision.business.entity.mybatis.EquipmentInputItemRo;
import com.yeejoin.amos.supervision.business.util.Toke;
import com.yeejoin.amos.supervision.dao.entity.InputItem;

import java.util.HashMap;
import java.util.List;

/**
 * @author keyong
 * @title: IEquipmentHandler
 * <pre>
 * @description: 站端接受装备信息系统数据处理流程
 * </pre>
 * @date 2020/11/10 18:01
 */
public interface IEquipmentHandlerService {
    /**
     * 规则系统发起请求
     *
     * @param toke
     * @param map
     * @param token
     * @return
     */
    void fireEquipRuleMessagePush(HashMap<String, Object> map, Toke token);


    /**
     * 根据code和装备名称查询装备
     *
     * @param orgCode
     * @param equipmentName
     * @return
     */

    public List<InputItem> getEquipmnetRules(String orgCode, String equipmentName);
    /**
     * 根据code和装备名称查询装备
     *
     * @return
     */
    public List<InputItem> getEquipmnetRulesByName( String equipmentName);

    /**
     * 根据code和装备名称查询装备
     *
     * @param rulesCheckList
     * @param toke
     * @return
     */
    public void getRulesCheckResult(List<EquipmentInputItemRo> rulesCheckList , Toke toke);


}
