package com.yeejoin.amos.adpter.controller;


import com.yeejoin.amos.adpter.service.AdpterService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.util.Map;


/**
 * 同步接口
 *
 * @author system_generator
 * @date 2021-06-29
 */
@RestController
@Slf4j
@Api(tags = "同步接口Api")
@RequestMapping(value = "/adpter")
public class AdpterController {


    @Autowired
    AdpterService adpterService;

    /**
     * 同步接口Api
     *
     * @return
     */
    @GetMapping(value = "/tran")
    @ApiOperation(httpMethod = "GET", value = "同步接口Api", notes = "同步接口Api")
    public Map<String,String> tran() {
        Map<String, String> handle = adpterService.handle();
        return handle;
    }

    /**
     * 数据库脚本执行Api
     *
     * @return
     */
    @PostMapping(value = "/execute/file")
    @ApiOperation(httpMethod = "POST", value = "脚本执行接口Api", notes = "脚本执行接口Api")
    public void executeSqlFile(HttpServletRequest request, HttpServletResponse response, @RequestParam(value = "dbHost") String dbHost, @RequestParam(value = "port") String port,
                                 @RequestParam(value = "dbName") String dbName, @RequestParam(value = "userName") String userName,
                                 @RequestParam(value = "dbPwd") String dbPwd, @RequestPart(value = "file") MultipartFile file) throws UnsupportedEncodingException {
        adpterService.executeSqlFile(request, response, dbHost, port, dbName, userName, dbPwd, file);
    }

}