package com.yeejoin.amos.boot.module.tcm.api.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.module.tcm.api.dto.GroupAndPersonInfoDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzIndividualityDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsEquipListDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsUserInfoDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzsUserQualifications;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

public interface ITzsUserInfoService extends IService<TzsUserInfo> {

    Page<TzsUserInfoDto> page(TzsUserInfoDto dto, Page<TzsUserInfoDto> page, String sort);

    void addQualificationsMessage(String userId, List<TzsUserQualifications> list);

    void updateQualificationsMessage(String userId, List<TzsUserQualifications> list);

    void deleteBatch(Object[] ids);

    Map<String, Object> getDetail(Long id, ReginParams reginParams);

    boolean BindAccount(Map<String, Object> map);

    String startOrStopAccount(Map<String, Object> map);

    List<Map<String, Object>> getEquipmentType(String creditCode);

    List<Map<String, Object>> getUserAllPostType();

    List<DataDictionary> getSubPostByParentsIds(String postIds);

    Boolean personnelTransferOut(String userSeqNbrs);

    JSONObject statisticsOfPersonnelTypes(String type);

    JSONObject statisticsOfPersonnelTypesByPatentCode(String parentId);

    Map<String, Integer> getArrangementStatistic(String companyCode);

    Map<String, Object> getCompanyType();

    Map<String, Object> getCompanyTypeForRedis(ReginParams selectedOrgInfo);

    Page<TzsEquipListDto> getEquipList(String type, String userSeq, TzsEquipListDto dto, Page<TzsEquipListDto> page);

    Boolean equipBind(String type, String userSeq, String creditCode, Map<String, Object> map);

    List<TzsUserInfo> getSafetyList(String companyCode);

    List<Map<String, Object>> getGroupList();

    Map<String, Object> getPersonType();

    List<GroupAndPersonInfoDto> getGroupAndPersonInfo(Long groupId);

    Boolean createUnitPerson();

    void testGroup(String groupSeq);

    void deleteGroupAndPersonRelation(String postName, String amosUserId);

    TzIndividualityDto getIndividualityInfo();

    TzIndividualityDto updateIndividualityInfo(TzIndividualityDto individualityDto);

    void userInfoExport(HttpServletResponse response, List<String> ids);

    /**
     * 批量导入人员
     *
     * @param file 导入的文件
     * @return 失败时返回失败信息，提供时返回success
     */
    ResponseModel<?> importUserBatch(MultipartFile file);

    /**
     * 企业人员导入
     *
     * @param file 导入的文件
     * @return 失败时返回失败信息，提供时返回success
     */
    ResponseModel<?> importCompanyUser(MultipartFile file, ReginParams reginParams);

    String deletePersonSubtypeHistoricalData();

    List<DataDictionary> postByUnitType(CompanyBo company,String formType);

    List<DataDictionary> subPostByUnitType(CompanyBo company, String parentCode);

    TzIndividualityDto individualityByCompanyCode(String companyCode);

    TzIndividualityDto personalInfoUpdateById(Map<String, Object> map);

    IPage<JSONObject> queryESForPage(ReginParams reginParams, String current, String size, String sort, Map<String, String> map);
}
