package com.yeejoin.amos.boot.module.jg.biz.edit.backup;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.biz.service.*;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentClassifityEnum;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Component
@RequiredArgsConstructor
public class TechParamsBackupService {
    private final IIdxBizJgTechParamsElevatorService iIdxBizJgTechParamsElevatorService;
    private final IIdxBizJgTechParamsVehicleService iIdxBizJgTechParamsVehicleService;
    private final IIdxBizJgTechParamsRopewayService iIdxBizJgTechParamsRopewayService;
    private final IIdxBizJgTechParamsRidesService iIdxBizJgTechParamsRidesService;
    private final IIdxBizJgTechParamsBoilerService iIdxBizJgTechParamsBoilerService;
    private final IIdxBizJgTechParamsVesselService iIdxBizJgTechParamsVesselService;
    private final IIdxBizJgTechParamsPipelineService iIdxBizJgTechParamsPipelineService;
    private final IIdxBizJgTechParamsLiftingService iIdxBizJgTechParamsLiftingService;

    public Object getTechParams(String equList, String record) {
        EquipmentClassifityEnum equipmentClassifityEnum = EquipmentClassifityEnum.getOne(equList);
        switch (Objects.requireNonNull(equipmentClassifityEnum)) {
            case GL:
                // 锅炉
                return iIdxBizJgTechParamsBoilerService.getOneData(record);
            case YLRQ:
                // 压力容器
                return iIdxBizJgTechParamsVesselService.getOneData(record);
            case DT:
                // 电梯
                return iIdxBizJgTechParamsElevatorService.getOneData(record);
            case QZJX:
                // 起重机械
                return iIdxBizJgTechParamsLiftingService.getOneData(record);
            case CC:
                // 场（厂）内专用机动车辆
                return iIdxBizJgTechParamsVehicleService.getOneData(record);
            case YLSS:
                // 大型游乐设施
                return iIdxBizJgTechParamsRidesService.getOneData(record);
            case YLGD:
                // 压力管道
                return iIdxBizJgTechParamsPipelineService.getOneData(record);
            case KYSD:
                // 客运索道
                return iIdxBizJgTechParamsRopewayService.getOneData(record);
            default:
                break;
        }
        return null;
    }

    public void save(String equList, String json) {
        EquipmentClassifityEnum equipmentClassifityEnum = EquipmentClassifityEnum.getOne(equList);
        switch (Objects.requireNonNull(equipmentClassifityEnum)) {
            case GL:
                // 锅炉
                IdxBizJgTechParamsBoiler bizJgTechParamsBoiler = JSONObject.parseObject(json, IdxBizJgTechParamsBoiler.class);
                iIdxBizJgTechParamsBoilerService.saveOrUpdate(bizJgTechParamsBoiler);
            case YLRQ:
                // 压力容器
                IdxBizJgTechParamsVessel techParamsVessel = JSONObject.parseObject(json, IdxBizJgTechParamsVessel.class);
                iIdxBizJgTechParamsVesselService.saveOrUpdate(techParamsVessel);
            case DT:
                // 电梯
                IdxBizJgTechParamsElevator techParamsElevator = JSONObject.parseObject(json, IdxBizJgTechParamsElevator.class);
                iIdxBizJgTechParamsElevatorService.saveOrUpdate(techParamsElevator);
            case QZJX:
                // 起重机械
                IdxBizJgTechParamsLifting jgTechParamsLifting = JSONObject.parseObject(json, IdxBizJgTechParamsLifting.class);
                iIdxBizJgTechParamsLiftingService.saveOrUpdate(jgTechParamsLifting);
            case CC:
                // 场（厂）内专用机动车辆
                IdxBizJgTechParamsVehicle techParamsVehicle = JSONObject.parseObject(json, IdxBizJgTechParamsVehicle.class);
                iIdxBizJgTechParamsVehicleService.saveOrUpdate(techParamsVehicle);
            case YLSS:
                // 大型游乐设施
                IdxBizJgTechParamsRides techParamsRides = JSONObject.parseObject(json, IdxBizJgTechParamsRides.class);
                iIdxBizJgTechParamsRidesService.saveOrUpdate(techParamsRides);
            case YLGD:
                // 压力管道
                IdxBizJgTechParamsPipeline techParamsPipeline = JSONObject.parseObject(json, IdxBizJgTechParamsPipeline.class);
                iIdxBizJgTechParamsPipelineService.saveOrUpdate(techParamsPipeline);
            case KYSD:
                // 客运索道
                IdxBizJgTechParamsRopeway techParamsRopeway = JSONObject.parseObject(json, IdxBizJgTechParamsRopeway.class);
                iIdxBizJgTechParamsRopewayService.saveOrUpdate(techParamsRopeway);
            default:
                break;
        }
    }
}
