package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum EquipStateEnum {

    /**
     * *设备状态
     */

//    WDJ("未登记", "0"),
    ZY("在用", "1"),
    TY("停用", "2"),
    ZX("注销", "4"),
    BF("报废", "3"),
    WZT("无", "99"),
    ;

    private String name;
    private String code;

    public static Map<String, String> getName = new HashMap<>();
    public static Map<String, String> getCode = new HashMap<>();


    static {
        for (EquipStateEnum e : EquipStateEnum.values()) {
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }
    }

    public static JSONArray getAll() {
        JSONArray jsonArray = new JSONArray();
        for (EquipStateEnum e : EquipStateEnum.values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label", e.name);
            jsonObject.put("value", e.code);
            jsonObject.put("key", e.code);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    public static String getNameByCode(String code) {
        for (EquipStateEnum e : EnumSet.allOf(EquipStateEnum.class)) {
            if (e.getCode().equals(code)) {
                return e.getName();
            }
        }
        return null;
    }
}
