package com.yeejoin.amos.boot.module.cylinder.flc.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.*;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.CylinderInfo;

import java.util.List;
import java.util.Map;

/**
 * 气瓶基本信息 Mapper 接口
 *
 * @author duanwei
 * @date 2022-08-11
 */
public interface TzCylinderMapper extends BaseMapper<CylinderInfo> {

    IPage<TzCylinderInfoDto> getTzCylinderInfoList(Page<TzCylinderInfoDto> page, TzCylinderInfoDto tzCylinderInfoDto, String superviseOrgCode);

    TzCylinderInfoDto getTzCylinderInfoDto(String sequenceNbr);

    Map<String, Object> getSequencCode(String sequenceNbr);

    TzCylinderProduceDto getTzCylinderProduceDto(String sequenceCode, String appId);

    TzCylinderTagsDto getTzCylinderTagsDto(String sequenceCode, String appId);

    List<TzCylinderInspectionDto> getTzCylinderInspectionDto(String sequenceCode, String appId);

    List<TzCylinderFillingDto> getTzCylinderFillingDto(String sequenceCode);

    TzCylinderBeforeCheckDto getTzCylinderBeforeCheck(String fillingBeforeId);

    List<TzCylinderCheckDto> getTzCylinderCheckItem();

    TzCylinderAfterCheckDto getTzCylinderAfterCheck(String fillingCheckId);

    List<TzCylinderCheckDto> getTzCylinderAfterCheckItem();



}
