package com.yeejoin.amos.boot.module.cylinder.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 
 * 动态表单值
 * */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="AlertCalledFormDto", description=" 动态表单值")
public class AlertCalledFormDto extends BaseDto{
	
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "警情基本信息")
	 private AlertCalledDto alertCalledDto;

	 @ApiModelProperty(value = "动态表单值")
	 private List<FormValue> dynamicFormAlert;

	@ApiModelProperty(value = "报警录音")
	 private String alertRecord;


	public AlertCalledFormDto(AlertCalledDto alertCalledDto, List<FormValue> formValue, String alertRecord) {
		this.alertCalledDto = alertCalledDto;
		this.dynamicFormAlert = formValue;
		this.alertRecord = alertRecord;
	}
}
