package com.yeejoin.amos.boot.module.tcm.biz.controller;

import com.yeejoin.amos.boot.module.tcm.biz.service.impl.HistoryDataDealServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@RestController
@RequestMapping(value = "/history-data")
@Api(tags = "历史数据处理控制器")
public class HistoryDataDealController {

    private HistoryDataDealServiceImpl historyDataDealService;

    public HistoryDataDealController(HistoryDataDealServiceImpl historyDataDealService) {
        this.historyDataDealService = historyDataDealService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/user-permission/update")
    @ApiOperation(httpMethod = "PUT", value = "人员需求2970新增资质后, 检验检测资质存量数据刷库")
    public ResponseModel<Integer> userPermissionUpdate() {
        return ResponseHelper.buildResponse(historyDataDealService.userPermissionUpdate());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/user-person-type/update")
    @ApiOperation(httpMethod = "PUT", value = "人员需求2970新增资质后, 人员类型去掉维保，归到作业人员")
    public ResponseModel<Integer> userPersonTypeUpdate() {
        return ResponseHelper.buildResponse(historyDataDealService.userPersonTypeUpdate());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/orgCode/update")
    @ApiOperation(httpMethod = "PUT", value = "企业orgCode调整历史数据修复")
    public ResponseModel<Boolean> unitOrgCodeUpdate(@RequestParam String oldOrgCode, @RequestParam String newOrgCode) {
        return ResponseHelper.buildResponse(historyDataDealService.unitOrgCodeUpdate(oldOrgCode, newOrgCode));
    }

    @Deprecated
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/handleCompanyHisOrgCode")
    @ApiOperation(httpMethod = "PUT", value = "监管单位层级调整后，业务表（企业、设备、统计等）冗余的所有旧orgCode替换为新orgCode，不更新平台表", notes = "监管单位层级调整后，业务表（企业、设备、统计等）冗余的所有旧orgCode替换为新orgCode，不更新平台表")
    public ResponseModel<String> handleCompanyHisOrgCode(@RequestBody List<Map<String, Object>> orgCodeMap) {
        return ResponseHelper.buildResponse(historyDataDealService.handleCompanyHisOrgCode(orgCodeMap));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/handleCompanyAppId")
    @ApiOperation(httpMethod = "PUT", value = "修复未生成appId的旧企业数据", notes = "修复未生成appId的旧企业数据")
    public ResponseModel<String> handleCompanyAppId(@RequestBody(required = false) List<String> useUnitCodes) {
        return ResponseHelper.buildResponse(historyDataDealService.handleCompanyAppId(useUnitCodes));
    }
}
