package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;

/**
* 统一门户、监管平台账号对应关系表
*
* @author tb
* @date 2024-12-31
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("sso_account_relation")
@ApiModel(value="统一门户、监管平台账号对应关系对象", description="统一门户、监管平台账号对应关系表")
public class SSOAccountRelation extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "统一门户用户ID")
    private String portalUserId;

    @ApiModelProperty(value = "统一门户用户手机号")
    private String portalUserPhone;

    @ApiModelProperty(value = "登录监管平台状态（1成功，0失败）")
    private String loginStatus;

    @ApiModelProperty(value = "创建日期")
    private Date createDate;

}
