package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.openapi.feign.TzsJgServiceFeignClient;
import com.yeejoin.amos.boot.module.cylinder.api.dto.PageParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import java.util.Date;

/**
 * 特种设备监管controller
 */
@RestController
@Api(tags = "榆林数据对接Api")
@RequestMapping(value = "/yulin")
public class YuLinDataDockController {

	@Autowired
	private TzsJgServiceFeignClient jgServiceFeignClient;

	/**
	 * 根据时间范围查询电梯数据
	 * @param equCode 设备代码
	 * @param startTime 开始时间
	 * @param endTime 结束时间
	 * @param pageParam 分页参数
	 * @return 电梯数据
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getElevatorInfo")
	@ApiOperation(httpMethod = "GET", value = "查询电梯信息列表", notes = "查询电梯信息列表")
	public ResponseModel<Object> getElevatorInfo(@RequestParam(value = "equCode", required = false) String equCode,
												 @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date startTime,
												 @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date endTime,
											     PageParam pageParam) {
		return ResponseHelper.buildResponse(jgServiceFeignClient.getElevatorInfo(equCode, startTime, endTime, pageParam.getCurrent(), pageParam.getSize()));
	}

	/**
	 * 根据时间范围查询液化石油气瓶档案
	 * @param equCode 设备代码
	 * @param startTime 开始时间
	 * @param endTime 结束时间
	 * @param pageParam 分页参数
	 * @return 石油气瓶档案
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getCylinderInfo")
	@ApiOperation(httpMethod = "GET", value = "根据时间范围查询液化石油气瓶档案", notes = "根据时间范围查询液化石油气瓶档案")
	public ResponseModel<Object> getCylinderInfo(@RequestParam(value = "equCode", required = false) String equCode,
											     @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date startTime,
											     @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date endTime,
											     PageParam pageParam) {
		return ResponseHelper.buildResponse(jgServiceFeignClient.getCylinderInfo(equCode, startTime, endTime, pageParam.getCurrent(), pageParam.getSize()));
	}

	/**
	 * 车用气气瓶档案
	 * @param useCode 气站统一信用代码
	 * @return 车用气气瓶档案
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getVehicleCylinderInfo")
	@ApiOperation(httpMethod = "GET", value = "车用气气瓶档案", notes = "车用气气瓶档案")
	public ResponseModel<Object> getVehicleCylinderInfo(@RequestParam(value = "useCode") String useCode) {
		return ResponseHelper.buildResponse(jgServiceFeignClient.getVehicleCylinderInfo(useCode));
	}

	/**
	 * 查询气站信息
	 * @return 气站信息
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getCylinderStationInfo")
	@ApiOperation(httpMethod = "GET", value = "查询气站信息", notes = "查询气站信息")
	public ResponseModel<Object> getCylinderStationInfo() {
		return ResponseHelper.buildResponse(jgServiceFeignClient.getCylinderStationInfo());
	}
}
