package com.yeejoin.amos.api.openapi.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 压力容器
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SpecialPresContainerModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;
    /**
     * 设备全省唯一编号
     */
    private String sequenceCode;
    /**
     * 容器内径（mm）
     */
    private String containerBore;
    /**
     * 筒体材料
     */
    private String cylinderMaterial;
    /**
     * 封头材料
     */
    private String headMaterial;
    /**
     * 内衬材料
     */
    private String liningMaterial;
    /**
     * 夹套材料
     */
    private String jacketMaterial;
    /**
     * 筒体厚度（mm）
     */
    private String cylinderThickness;
    /**
     * 封头厚度（mm）
     */
    private String headThickness;
    /**
     * 内衬厚度（mm）
     */
    private String liningThickness;
    /**
     * 夹套厚度（mm）
     */
    private String jacketThickness;
    /**
     * 容器容积m³
     */
    private String containerVolume;
    /**
     * 容器高（长）（mm）
     */
    private String containerHigh;
    /**
     * 壳体重量（Kg）
     */
    private String shellWeight;
    /**
     * 内件重量（Kg）
     */
    private String internalsWeight;
    /**
     * 充装重量（Kg）
     */
    private String fillingWeight;
    /**
     * 有无保温绝热
     */
    private String isThermalInsulation;
    /**
     * 壳程设计压力（MPa）
     */
    private String shellDesignPressure;
    /**
     * 壳程设计温度（℃）
     */
    private String shellDesignTemperature;
    /**
     * 壳程最高压力（MPa）
     */
    private String shellHighestPressure;
    /**
     * 管程设计压力（MPa）
     */
    private String tubeDesignPressure;
    /**
     * 管程设计温度（℃）
     */
    private String tubeDesignTemperature;
    /**
     * 管程最高工作压力（MPa）
     */
    private String tubeHighestPressure;
    /**
     * 夹套设计压力（MPa）
     */
    private String jacketDesignPressure;
    /**
     * 夹套设计温度（℃）
     */
    private String jacketDesignTemperature;
    /**
     * 夹套最高工作压力（MPa）
     */
    private String jacketHighestPressure;
    /**
     * 壳程介质
     */
    private String shellMedium;
    /**
     * 管程介质
     */
    private String tubeMedium;
    /**
     * 夹套介质
     */
    private String jacketMedium;
    /**
     * 氧舱照明
     */
    private String oxygenLighting;
    /**
     * 氧舱空调电机
     */
    private String oxygenAirConditioning;
    /**
     * 氧舱测氧方式
     */
    private String oxygenMeasurementMode;
    /**
     * 罐车牌号
     */
    private String potCarNum;
    /**
     * 罐车结构型式
     */
    private String potCarStructuralStyle;
    /**
     * 罐车底盘号码
     */
    private String potCarChassisNum;

}
