package com.yeejoin.amos.boot.module.elevator.api.entity;

import java.util.Date;

import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 特种设备检验信息
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_jg_inspection_info")
@ApiModel(value="TzsJgInspectionInfo对象", description="特种设备检验信息")
public class TzsJgInspectionInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "设备唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "监管系统唯一编码")
    private String superviseCode;

    @ApiModelProperty(value = "设备代码")
    private String equCode;

    @ApiModelProperty(value = "检验类型(1法定类监督检验2法定类定期检验3非法定类检验4委托类检验)")
    private String inspectType;

    @ApiModelProperty(value = "检验机构名称")
    private String inspectOrgName;

    @ApiModelProperty(value = "检验报告ID")
    private String inspectReportNum;

    @ApiModelProperty(value = "检验人员")
    private String inspectStaff;

    @ApiModelProperty(value = "检验日期")
    private Date inspectDate;

    @ApiModelProperty(value = "检验结论(合格，复检合格等)")
    private String inspectConclusion;

    @ApiModelProperty(value = "安全状况等级")
    private String safetyLevel;

    @ApiModelProperty(value = "检验问题备注")
    private String problemRemark;

    @ApiModelProperty(value = "下次检验日期")
    private Date nextInspectDate;

    @ApiModelProperty(value = "同步时间")
    private Date syncDate;

    @ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

}
