package com.yeejoin.amos.boot.module.elevator.api.entity;

import java.util.Date;

import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
/**
 * 人员数据信息-基本信息
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
@Accessors(chain = true)
@TableName("tz_jg_staff_base_info")
@ApiModel(value="TzsJgStaffBaseInfo对象", description="人员数据信息-基本信息")
public class TzsJgStaffBaseInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "作业人员姓名")
    private String operator;

    @ApiModelProperty(value = "作业人员证件类型")
    private String operatorIdType;

    @ApiModelProperty(value = "作业人员身份号码")
    private String operatorId;

    @ApiModelProperty(value = "性别")
    private String gender;

    @ApiModelProperty(value = "联系电话")
    private String phone;

    @ApiModelProperty(value = "工作单位代码")
    private String unitCode;

    @ApiModelProperty(value = "工作单位名称")
    private String unit;

    @ApiModelProperty(value = "聘用时间")
    private Date employmentDate;

    @ApiModelProperty(value = "同步时间")
    private Date syncDate;

    @ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;


}
