package com.yeejoin.amos.boot.module.common.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 消防水源物联参数
 *
 * @author litw
 * @date 2021-11-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="WaterResourceIndexDto", description="消防水源物联参数")
public class WaterResourceIndexDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    private Long id;

    @ApiModelProperty(value = "指标拥有者ID:关联装备定义ID")
    private Long equipmentId;

    @ApiModelProperty(value = "消防水源id")
    private Long waterId;

    @ApiModelProperty(value = "名称")
    private String name;

    private String nameKey;

    @ApiModelProperty(value = "指标值")
    private String perfValue;

}
