package com.yeejoin.amos.boot.module.jczs.flc.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jczs.flc.biz.service.impl.TaskServiceImpl;
import com.yeejoin.amos.boot.module.jczs.flc.api.enums.TaskStatusEnum;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.Date;
import java.util.List;

import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jczs.flc.api.dto.TaskDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 任务表
 *
 * @author system_generator
 * @date 2022-05-31
 */
@RestController
@Api(tags = "任务表Api")
@RequestMapping(value = "/task")
public class TaskController extends BaseController {

    @Autowired
    TaskServiceImpl taskServiceImpl;

    /**
     * 新增任务表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增任务表", notes = "新增任务表")
    public ResponseModel<TaskDto> save(@RequestBody TaskDto model) {
        model.setCreateDate(new Date());
        model.setUserId(RequestContext.getExeUserId());
        model = taskServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新任务表", notes = "根据sequenceNbr更新任务表")
    public ResponseModel<TaskDto> updateBySequenceNbrTask(@RequestBody TaskDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(taskServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除任务表", notes = "根据sequenceNbr删除任务表")
    public ResponseModel deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        taskServiceImpl.deleteById(sequenceNbr);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个任务表", notes = "根据sequenceNbr查询单个任务表")
    public ResponseModel<TaskDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(taskServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @param status TODO(uncomplete: 待办，complete：已办)
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "任务表分页查询", notes = "任务表分页查询")
    public ResponseModel<Page<TaskDto>> queryForPage(@RequestParam(value = "current") int current,
                                                     @RequestParam(value = "size") int size,
                                                     @RequestParam(value = "sendTimeStart", required = false) String sendTimeStart,
                                                     @RequestParam(value = "sendTimeEnd", required = false) String sendTimeEnd,
                                                     @RequestParam(value = "taskType", required = false) String taskType,
                                                     @RequestParam(value = "status", required = false) String status,
                                                     @RequestParam(value = "content", required = false) String content) {
        Page<TaskDto> page = new Page<TaskDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(taskServiceImpl.queryForTaskPageByParams(page, RequestContext.getExeUserId(), sendTimeStart, sendTimeEnd, taskType, status, content));
    }

    /**
     * 统计任务数量
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "任务数量查询", notes = "任务数量查询")
    @GetMapping(value = "/queryCount")
    public ResponseModel<JSONObject> queryCountForMap() {
        return ResponseHelper.buildResponse(taskServiceImpl.queryCountForMap(RequestContext.getExeUserId()));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "任务表列表全部数据查询", notes = "任务表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<TaskDto>> selectForList() {
        return ResponseHelper.buildResponse(taskServiceImpl.queryForTaskList());
    }
}
