package com.yeejoin.amos.boot.module.jg.biz.reminder.biz.factory;

import com.yeejoin.amos.boot.module.jg.biz.reminder.core.IReminderHandler;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
@RequiredArgsConstructor
public class ReminderFactory {
    private final List<IReminderHandler> reminderHandlers;

    private final Map<String, IReminderHandler> reminderHandlerMap = new ConcurrentHashMap<>();


    public IReminderHandler getReminderHandler(String bizType) {
        return reminderHandlerMap.computeIfAbsent(bizType, (k) -> {
            for (IReminderHandler handler : reminderHandlers) {
                if (handler.supportBizType().equals(bizType)) {
                    return handler;
                }
            }
            throw new BadRequest("not found reminder handler for " + bizType);
        });
    }

}
