package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.yeejoin.amos.boot.module.jg.api.dto.CompanyEquipCountDto;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgOverDesignServiceLifeMapper;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author LiuLin
 */
@Component
@Slf4j
public class JgOverDesignServiceLifeCheckImpl extends BaseEquipUsedCheckService {

    private RedissonClient redissonClient;

    private String bizType = "overDesignServiceLife";

    private JgOverDesignServiceLifeMapper overDesignServiceLifeMapper;

    public JgOverDesignServiceLifeCheckImpl(RedissonClient redissonClient, JgOverDesignServiceLifeMapper overDesignServiceLifeMapper) {
        this.redissonClient = redissonClient;
        this.overDesignServiceLifeMapper = overDesignServiceLifeMapper;
    }


    @Override
    public RedissonClient getRedisClient() {
        return redissonClient;
    }

    @Override
    public String getApplyBizType() {
        return bizType;
    }


    @Override
    public void init() {
        // 初始化在流程中设备数据
        List<CompanyEquipCountDto> companyEquipCountDtos = overDesignServiceLifeMapper.queryForFlowingEquipList();
        companyEquipCountDtos.remove(null);
        companyEquipCountDtos.forEach(c -> {
            RBucket<Set<String>> rBucket = redissonClient.getBucket(getFlowingEquipRedisKey(c.getCompanyCode(), bizType));
            rBucket.set(Arrays.stream(c.getRecords().split(",")).collect(Collectors.toSet()));
        });
    }
}
