package com.yeejoin.amos.boot.module.jyjc.biz.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;

/**
 * 各检验检测类型是否启用规则，默认不启用
 * @author Administrator
 */
@Component
@ConfigurationProperties(prefix = "inspection.rule.enabled")
@Data
public class InspectionRuleEnableConfig {

    /**
     * 定期检验是否启用规则：true-启用，false-不启用
     */
    private Boolean DQJY;

    /**
     * 首次检验是否启用规则：true-启用，false-不启用
     */
    private Boolean SCJY;

    /**
     * 维修监督检验是否启用规则：true-启用，false-不启用
     */
    private Boolean WXJDJY;

    /**
     * 改造监督检验是否启用规则：true-启用，false-不启用
     */
    private Boolean GZJDJY;

    /**
     * 安装监督检验是否启用规则：true-启用，false-不启用
     */
    private Boolean AZJDJY;

    /**
     * 电梯检测是否启用规则：true-启用，false-不启用
     */
    private Boolean DTJC;

    /**
     * 委托检验是否启用规则：true-启用，false-不启用
     */
    private Boolean WTJY;

    public Object getValueByFieldName(String fieldName){
        Field field = null;
        try {
            field = this.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(this);
        } catch (NoSuchFieldException | IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

}