package com.yeejoin.amos.boot.module.jyjc.biz.feign;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.amos.boot.module.jyjc.api.model.JgResumeInfoDto;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import java.util.List;
import java.util.Map;

@FeignClient(contextId = "jyjc", name = "${tzsJg.feign.name:TZS-JG}", path = "jg", configuration = {MultipartSupportConfig.class})
public interface JgFeignClient {

    /***
     * 设备注册信息分页查询
     *
     * */
    @RequestMapping(value = "/equipment-register/page", method = RequestMethod.GET)
    FeignClientResult<Page<JSONObject>> queryForPage(@RequestParam Map<String, Object> map);

    /***
     * 设备注册信息分页查询
     * */
    @RequestMapping(value = "/jg-resume-info/saveBatchResume", method = RequestMethod.POST)
    FeignClientResult saveBatchResume(@RequestBody List<JgResumeInfoDto> jgResumeInfoDtoList);
}

